/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.Application;
import com.storedobject.vaadin.ClickHandler;
import com.storedobject.vaadin.ImageButton;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;

@Tag(value="span")
public class SpeakerButton
extends Component
implements Application.SpeakerToggledListener {
    private final ImageButton icon = new ImageButton(VaadinIcon.SOUND_DISABLE, (ClickHandler & Serializable)c -> {
        Application a = Application.get();
        if (a != null) {
            a.setSpeaker(!a.isSpeakerOn());
        }
    });
    private Registration registration;

    public SpeakerButton() {
        this.icon.getElement().setAttribute("onclick", "this.blur()");
        this.icon.getElement().setAttribute("tabindex", "-1");
        this.getElement().setAttribute("title", "Toggle speaker output");
        this.getElement().setAttribute("onclick", "window.speechSynthesis.speak(new SpeechSynthesisUtterance('Speaker output toggled'));this.blur()");
        this.getElement().appendChild(new Element[]{this.icon.getElement()});
        this.icon.setColor("var(--so-header-color)");
    }

    protected void onAttach(AttachEvent attachEvent) {
        Application a;
        super.onAttach(attachEvent);
        if (this.registration == null && (a = Application.get()) != null) {
            this.registration = a.addSpeakerToggedListener(this);
            this.speaker(a.isSpeakerOn());
        }
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        if (this.registration != null) {
            this.registration.remove();
            this.registration = null;
        }
    }

    @Override
    public void speaker(boolean on) {
        this.icon.setIcon(on ? VaadinIcon.VOLUME_UP : VaadinIcon.SOUND_DISABLE);
    }

    public SpeakerButton withBox() {
        return this.withBox(25);
    }

    public SpeakerButton withBox(int sizeInPixels) {
        this.icon.withBox(sizeInPixels);
        return this;
    }

    public void setColor(String color) {
        this.icon.setColor(color);
    }
}

