/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.Button;
import com.storedobject.vaadin.ButtonLayout;
import com.storedobject.vaadin.ClickHandler;
import com.storedobject.vaadin.ListGrid;
import com.storedobject.vaadin.MultiSelectGrid;
import com.storedobject.vaadin.View;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridMultiSelectionModel;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class SelectGrid<T>
extends ListGrid<T> {
    private String emptyRowsMessage = "No entries found!";
    protected final ButtonLayout buttonLayout = new ButtonLayout();
    protected final Button proceed = new Button("Proceed", (ClickHandler & Serializable)e -> this.act());
    protected final Button cancel = new Button("Cancel", (ClickHandler & Serializable)e -> this.cancel());
    private final Consumer<Object> consumer;

    public SelectGrid(Class<T> objectClass, List<T> items) {
        this(objectClass, items, (Consumer)null);
    }

    public SelectGrid(Class<T> objectClass, List<T> items, Iterable<String> columns) {
        this(objectClass, items, columns, null);
    }

    public SelectGrid(Class<T> objectClass, List<T> items, Consumer<T> consumer) {
        this(objectClass, items, null, consumer);
    }

    public SelectGrid(Class<T> objectClass, List<T> items, Iterable<String> columns, Consumer<T> consumer) {
        this(objectClass, items, columns, consumer == null ? null : o -> consumer.accept(o), false);
    }

    SelectGrid(Class<T> objectClass, List<T> items, Iterable<String> columns, Consumer<Object> consumer, boolean multi) {
        super(objectClass, items, columns);
        this.consumer = consumer;
        this.setWidth("60vw");
        this.setHeight("60vh");
        if (multi) {
            this.setSelectionMode(Grid.SelectionMode.MULTI);
        } else {
            this.addItemDoubleClickListener((ComponentEventListener & Serializable)e -> this.act(e.getItem()));
        }
    }

    @Override
    public final Component createHeader() {
        this.addExtraButtons();
        this.buttonLayout.add(new Component[]{this.proceed, this.cancel});
        return this.buttonLayout;
    }

    public void addExtraButtons() {
    }

    @Override
    public void execute(View lock) {
        if (this.isEmpty()) {
            if (this.emptyRowsMessage != null) {
                this.warning(this.emptyRowsMessage);
            }
            return;
        }
        super.execute(lock);
    }

    private void act() {
        if (this.getSelectionModel() instanceof GridMultiSelectionModel) {
            if (!this.validate()) {
                return;
            }
            this.close();
            Set selected = this.getSelectedItems();
            if (this.consumer == null) {
                this.process((T)selected);
            } else {
                this.consumer.accept(selected);
            }
        } else {
            this.act(this.getSelected());
        }
    }

    private void act(T selected) {
        if (selected == null) {
            this.warning("Please select an entry");
            return;
        }
        if (!this.validate()) {
            return;
        }
        this.close();
        if (this.consumer == null) {
            this.process(selected);
        } else {
            this.consumer.accept(selected);
        }
    }

    protected void cancel() {
        this.abort();
    }

    protected void process(Set<T> selected) {
    }

    protected void process(T selected) {
    }

    @Override
    public final View createView() {
        return new SelectView();
    }

    public void setEmptyRowsMessage(String emptyRowsMessage) {
        this.emptyRowsMessage = emptyRowsMessage;
    }

    protected boolean validate() {
        return true;
    }

    private class SelectView
    extends View {
        private SelectView() {
            super("Select " + (SelectGrid.this instanceof MultiSelectGrid ? "Entries" : "an Entry"));
            this.setComponent((Component)SelectGrid.this);
            this.setWindowMode(true);
            String c = SelectGrid.this.getCaption();
            if (c != null && !c.isEmpty()) {
                this.setCaption(c);
            }
        }
    }
}

