/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.helper.ID;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.littemplate.LitTemplate;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;

@Tag(value="scary-cube")
@NpmPackage(value="resize-observer-polyfill", version="1.5.1")
@JsModule(value="./so/scarycube/scary-cube.js")
public class RubikCube
extends LitTemplate
implements HasSize {
    private boolean shuffled = false;
    private List<Consumer<RubikCube>> solvedListeners;

    public RubikCube() {
        ID.set((Component)this);
        this.setWidth("100%");
        this.setHeight("500px");
    }

    public void move(CharSequence moves) {
        if (moves == null || moves.length() == 0) {
            return;
        }
        boolean many = false;
        StringBuilder command = new StringBuilder();
        block4: for (int i = 0; i < moves.length(); ++i) {
            char c = moves.charAt(i);
            switch (c) {
                case ' ': {
                    continue block4;
                }
                case '\'': 
                case '2': {
                    command.append(c);
                    continue block4;
                }
                default: {
                    if (i > 0) {
                        command.append(' ');
                        many = true;
                    }
                    command.append(Character.toUpperCase(c));
                }
            }
        }
        this.getElement().callJsFunction("addMove" + (many ? "s" : ""), new Serializable[]{command.toString()});
    }

    public void reset() {
        this.getElement().callJsFunction("reset", new Serializable[0]);
    }

    public void shuffle(int moves) {
        if (moves <= 0) {
            return;
        }
        if (!this.shuffled) {
            this.shuffled = moves > 9;
        }
        Random random = new Random();
        StringBuilder m = new StringBuilder();
        block8: while (moves-- > 0) {
            int r = random.nextInt(9);
            m.append(this.moveChar(r));
            switch (r) {
                case 6: 
                case 7: 
                case 8: {
                    if (!random.nextBoolean()) continue block8;
                    m.append('\'');
                    continue block8;
                }
            }
            switch (random.nextInt(3)) {
                case 0: {
                    break;
                }
                case 1: {
                    m.append('\'');
                    break;
                }
                case 2: {
                    m.append('2');
                }
            }
        }
        this.move(m);
    }

    private char moveChar(int i) {
        switch (i) {
            case 0: {
                return 'F';
            }
            case 1: {
                return 'R';
            }
            case 2: {
                return 'U';
            }
            case 3: {
                return 'L';
            }
            case 4: {
                return 'B';
            }
            case 5: {
                return 'D';
            }
            case 6: {
                return 'M';
            }
            case 7: {
                return 'E';
            }
            case 8: {
                return 'S';
            }
        }
        return '\u0000';
    }

    @ClientCallable
    private void solved() {
        if (this.shuffled) {
            this.shuffled = false;
            if (this.solvedListeners != null) {
                this.solvedListeners.forEach(s -> s.accept(this));
            }
        }
    }

    public Registration addSolvedListener(Consumer<RubikCube> solvedListener) {
        if (this.solvedListeners == null) {
            this.solvedListeners = new ArrayList<Consumer<RubikCube>>();
        }
        this.solvedListeners.add(solvedListener);
        return (Registration & Serializable)() -> this.solvedListeners.remove(solvedListener);
    }
}

