/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.ResourcedComponent;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamRegistration;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.VaadinSession;

public class ResourceSupport {
    private StreamRegistration streamRegistration;
    private AbstractStreamResource streamResource;
    private final ResourcedComponent component;

    public ResourceSupport(ResourcedComponent component) {
        this.component = component;
    }

    public void clear() {
        this.unregister();
        this.streamResource = null;
    }

    public void register(AbstractStreamResource streamResource) {
        if (streamResource == null) {
            this.clear();
            return;
        }
        this.unregister();
        this.streamResource = streamResource;
        this.streamRegistration = VaadinSession.getCurrent().getResourceRegistry().registerResource(streamResource);
    }

    public void register() {
        if (this.streamResource != null && this.streamRegistration == null) {
            this.component.setSource(this.streamResource);
        }
    }

    public void unregister() {
        if (this.streamRegistration != null) {
            this.streamRegistration.unregister();
            this.streamRegistration = null;
        }
    }

    public String getURI() {
        return this.streamResource == null ? null : StreamResourceRegistry.getURI((AbstractStreamResource)this.streamResource).toASCIIString();
    }
}

