/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.radiobutton.RadioGroupVariant;
import com.vaadin.flow.component.radiobutton.dataview.RadioButtonGroupListDataView;
import com.vaadin.flow.component.shared.ThemeVariant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class RadioField<T>
extends RadioButtonGroup<T> {
    private RadioButtonGroupListDataView<T> view;

    public RadioField(T[] choices) {
        this(null, choices);
    }

    public RadioField(String label, T[] choices) {
        this(label, (Collection<T>)Arrays.asList(choices));
    }

    public RadioField(Iterable<T> choices) {
        this(null, choices);
    }

    public RadioField(String label, Collection<T> choices) {
        this.setItems(choices);
        this.setLabel(label);
    }

    public RadioField(String label, Iterable<T> choices) {
        this.setItems(RadioField.createList(choices));
        this.setLabel(label);
    }

    private static <O> List<O> createList(Iterable<O> choices) {
        ArrayList a = new ArrayList();
        choices.forEach(a::add);
        return a;
    }

    public RadioButtonGroupListDataView<T> setItems(Collection<T> items) {
        this.view = (RadioButtonGroupListDataView)super.setItems(items);
        if (!items.isEmpty()) {
            this.setValue(this.view.getItem(0));
        }
        return this.view;
    }

    public int getIndex() {
        return this.getIndex(this.getValue());
    }

    public int getIndex(T value) {
        for (int i = 0; i < this.view.getItemCount(); ++i) {
            if (!this.view.getItem(i).equals(value)) continue;
            return i;
        }
        return -1;
    }

    public T getValue(int index) {
        if (index >= 0 && index < this.view.getItemCount()) {
            return (T)this.view.getItem(index);
        }
        return null;
    }

    public void setIndex(int index) {
        if (index >= 0 && index < this.view.getItemCount()) {
            this.setValue(this.view.getItem(index));
        }
    }

    public void setVertical() {
        this.addThemeVariants((ThemeVariant[])new RadioGroupVariant[]{RadioGroupVariant.LUMO_VERTICAL});
    }

    public void setHorizontal() {
        this.removeThemeVariants((ThemeVariant[])new RadioGroupVariant[]{RadioGroupVariant.LUMO_VERTICAL});
    }
}

