/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.Button;
import com.storedobject.vaadin.ButtonLayout;
import com.storedobject.vaadin.ClickHandler;
import com.storedobject.vaadin.Icon;
import com.storedobject.vaadin.Window;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;

public class PopupTextField
extends TextField {
    private TextArea textArea;
    private Window window;
    private Span label;

    public PopupTextField() {
        this.init();
    }

    public PopupTextField(String label) {
        super(label);
        this.init();
    }

    public PopupTextField(String label, String placeholder) {
        super(label, placeholder);
        this.init();
    }

    public PopupTextField(String label, String initialValue, String placeholder) {
        super(label, initialValue, placeholder);
        this.init();
    }

    public PopupTextField(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextField, String>> listener) {
        super(listener);
        this.init();
    }

    public PopupTextField(String label, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextField, String>> listener) {
        super(label, listener);
        this.init();
    }

    public PopupTextField(String label, String initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextField, String>> listener) {
        super(label, initialValue, listener);
        this.init();
    }

    private void init() {
        Icon pop = new Icon(VaadinIcon.ELLIPSIS_DOTS_H);
        pop.setStyle("cursor", "pointer");
        this.setSuffixComponent((Component)pop);
        pop.addClickListener((ComponentEventListener<ClickEvent<Icon>>)(ComponentEventListener & Serializable)e -> this.pop());
    }

    private void pop() {
        String label;
        if (this.window == null) {
            this.createWindow();
        }
        if ((label = this.getLabel()) != null) {
            this.label.setText(label);
            this.label.getStyle().set("margin-left", "auto");
        } else {
            this.label.setText("");
        }
        this.textArea.setValue(this.getValue());
        this.window.open();
    }

    private void createWindow() {
        this.textArea = new TextArea();
        this.textArea.setWidth("600px");
        this.label = new Span();
        Button ok = new Button("Ok", (ClickHandler & Serializable)e -> {
            this.setValue(this.textArea.getValue());
            this.window.close();
        });
        Button cancel = new Button("Cancel", (ClickHandler & Serializable)e -> this.window.close());
        ButtonLayout buttonLayout = new ButtonLayout(new Component[]{ok, cancel, this.label});
        buttonLayout.setWidthFull();
        this.window = new Window(new Component[]{new Div(new Component[]{buttonLayout, this.textArea})});
    }

    public void setValue(String value) {
        super.setValue(value == null ? "" : value);
    }
}

