/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.Button;
import com.storedobject.vaadin.CSSGrid;
import com.storedobject.vaadin.GridLayout;
import com.storedobject.vaadin.Icon;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.contextmenu.ContextMenu;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.dom.Element;

public class PopupButton
extends Button {
    private ContextMenu menu;
    private final GridLayout container = new GridLayout(1);

    public PopupButton(String text) {
        super(text, null);
        this.init();
    }

    public PopupButton(Component icon) {
        super(icon, null);
        this.init();
    }

    public PopupButton(String text, String icon) {
        super(text, icon, null);
        this.init();
    }

    public PopupButton(String text, Component icon) {
        super(text, icon, null);
        this.init();
    }

    public PopupButton(VaadinIcon icon) {
        super(icon, null);
        this.init();
    }

    public PopupButton(String text, VaadinIcon icon) {
        super(text, icon, null);
        this.init();
    }

    private void init() {
        this.getElement().appendChild(new Element[]{new Icon(VaadinIcon.CHEVRON_DOWN_SMALL).getElement()});
        this.createMenu();
    }

    private void createMenu() {
        if (this.menu != null) {
            this.menu.setTarget(null);
            this.menu.removeAll();
        }
        this.menu = new ContextMenu();
        this.menu.setTarget((Component)this);
        this.menu.setOpenOnClick(true);
        this.menu.addItem((Component)this.container);
    }

    public void setColumns(int numberOfColumns) {
        this.container.setColumns(numberOfColumns);
    }

    public void add(Component ... components) {
        if (components != null) {
            this.container.add(components);
            for (Component c : components) {
                if (!(c instanceof HasSize)) continue;
                ((HasSize)c).setWidth("100%");
            }
        }
    }

    public void remove(Component ... components) {
        if (components != null) {
            this.container.remove(components);
        }
    }

    public void removeAll() {
        this.container.removeAll();
    }

    public void setColumnSpan(Component component, int columns) {
        this.container.setColumnSpan(component, columns);
    }

    public int getColumnSpan(Component component) {
        return this.container.getColumnSpan(component);
    }

    public void setRowSpan(Component component, int rows) {
        this.container.setRowSpan(component, rows);
    }

    public int getRowSpan(Component component) {
        return this.container.getRowSpan(component);
    }

    public void justify(Component component, CSSGrid.Position position) {
        this.container.justify(component, position);
    }

    public void align(Component component, CSSGrid.Position position) {
        this.container.align(component, position);
    }

    public void center(Component component) {
        this.container.center(component);
    }
}

