/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.PaintedImage;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class PaintedImageResource
extends StreamResource {
    private static long fileId = 0L;

    public PaintedImageResource() {
        this(PaintedImage.Type.SVG, null);
    }

    public PaintedImageResource(PaintedImage.Type type) {
        this(type, null);
    }

    public PaintedImageResource(int widthInPixels, int heightInPixels) {
        this(PaintedImage.Type.SVG, null, widthInPixels, heightInPixels);
    }

    public PaintedImageResource(PaintedImage.Type imageType, int widthInPixels, int heightInPixels) {
        this(imageType, null, widthInPixels, heightInPixels);
    }

    public PaintedImageResource(Consumer<Graphics2D> painter) {
        this(PaintedImage.Type.SVG, painter);
    }

    public PaintedImageResource(PaintedImage.Type type, Consumer<Graphics2D> painter) {
        this(type, painter, 100, 100);
    }

    public PaintedImageResource(Consumer<Graphics2D> painter, int widthInPixels, int heightInPixels) {
        this(PaintedImage.Type.SVG, painter, widthInPixels, heightInPixels);
    }

    public PaintedImageResource(PaintedImage.Type imageType, Consumer<Graphics2D> painter, int widthInPixels, int heightInPixels) {
        this(new ImageStream(imageType, widthInPixels, heightInPixels), painter);
    }

    private PaintedImageResource(ImageStream imageStream, Consumer<Graphics2D> painter) {
        super(PaintedImageResource.createBaseFileName() + "." + imageStream.imageType.toString().toLowerCase(), (InputStreamFactory)imageStream);
        this.setContentType((String)(imageStream.imageType == PaintedImage.Type.SVG ? "image/svg+xml" : "image/" + imageStream.imageType.toString().toLowerCase()));
        if (painter == null) {
            painter = this::paint;
        }
        imageStream.painter = painter;
    }

    public void paint(Graphics2D graphics) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createBaseFileName() {
        Class<PaintedImage> clazz = PaintedImage.class;
        synchronized (PaintedImage.class) {
            if (fileId == Long.MAX_VALUE) {
                fileId = 0L;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return "no-so" + ++fileId;
        }
    }

    private static class ImageStream
    implements InputStreamFactory {
        private final PaintedImage.Type imageType;
        private final int width;
        private final int height;
        private ByteArrayInputStream bytestream = null;
        private Consumer<Graphics2D> painter;

        private ImageStream(PaintedImage.Type imageType, int width, int height) {
            this.imageType = imageType;
            this.width = width;
            this.height = height;
        }

        public InputStream createInputStream() {
            if (this.bytestream == null) {
                BufferedImage bi = null;
                Object graphics = null;
                if (this.imageType == PaintedImage.Type.SVG) {
                    DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
                    Document document = domImpl.createDocument("http://www.w3.org/2000/svg", "svg", null);
                    graphics = new SVGGraphics2D(document);
                } else if (this.width > 0 && this.height > 0) {
                    bi = new BufferedImage(this.width, this.height, 5);
                    graphics = bi.createGraphics();
                }
                if (this.width > 0 && this.height > 0) {
                    ((Graphics)graphics).setClip(0, 0, this.width, this.height);
                    if (this.imageType != PaintedImage.Type.SVG) {
                        ((Graphics)graphics).setColor(Color.BLACK);
                        ((Graphics2D)graphics).setBackground(new Color(180, 192, 197));
                        ((Graphics)graphics).clearRect(0, 0, this.width, this.height);
                    }
                }
                if (graphics != null && this.painter != null) {
                    this.painter.accept((Graphics2D)graphics);
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                try {
                    if (this.imageType == PaintedImage.Type.SVG) {
                        OutputStreamWriter ow = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);
                        ((SVGGraphics2D)graphics).stream((Writer)ow);
                        ow.close();
                    } else {
                        ImageIO.write((RenderedImage)Objects.requireNonNull(bi), this.imageType.toString().toLowerCase(), outputStream);
                    }
                    outputStream.close();
                    this.bytestream = new ByteArrayInputStream(outputStream.toByteArray());
                    ((Graphics)graphics).dispose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.bytestream.reset();
            }
            return this.bytestream;
        }
    }
}

