/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.PaintedImageResource;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.server.AbstractStreamResource;
import java.awt.Graphics2D;
import java.util.function.Consumer;

public class PaintedImage
extends Image {
    private Consumer<Graphics2D> painter;
    private final Type type;
    private int widthInPixels;
    private int heightInPixels;

    public PaintedImage() {
        this(Type.SVG);
    }

    public PaintedImage(Type type) {
        this(type, null);
    }

    public PaintedImage(int widthInPixels, int heightInPixels) {
        this(Type.SVG, null, widthInPixels, heightInPixels);
    }

    public PaintedImage(Type type, int widthInPixels, int heightInPixels) {
        this(type, null, widthInPixels, heightInPixels);
    }

    public PaintedImage(Consumer<Graphics2D> painter) {
        this(Type.SVG, painter);
    }

    public PaintedImage(Type type, Consumer<Graphics2D> painter) {
        this(type, painter, 100, 100);
    }

    public PaintedImage(Type type, Consumer<Graphics2D> painter, int widthInPixels, int heightInPixels) {
        this.type = type;
        this.painter = painter;
        this.widthInPixels = widthInPixels;
        this.heightInPixels = heightInPixels;
        this.redraw();
    }

    public Type getType() {
        return this.type;
    }

    public void setImageWidth(int width) {
        this.widthInPixels = width;
        this.redraw();
    }

    public int getImageWidth() {
        return this.widthInPixels;
    }

    public void setImageHeight(int height) {
        this.heightInPixels = height;
        this.redraw();
    }

    public int getImageHeight() {
        return this.heightInPixels;
    }

    public void redraw() {
        this.setSrc((AbstractStreamResource)new PaintedImageResource(this.type, this::paint, this.widthInPixels, this.heightInPixels));
    }

    public void setPainter(Consumer<Graphics2D> painter) {
        this.painter = painter;
        this.redraw();
    }

    public Consumer<Graphics2D> getPainter() {
        return this.painter;
    }

    public void paint(Graphics2D graphics) {
        if (this.painter != null) {
            this.painter.accept(graphics);
        }
    }

    public static enum Type {
        SVG,
        PNG,
        JPG,
        GIF;

    }
}

