/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.helper.ID;
import com.storedobject.vaadin.AbstractDataEditor;
import com.storedobject.vaadin.AbstractDataForm;
import com.storedobject.vaadin.AbstractForm;
import com.storedobject.vaadin.Application;
import com.storedobject.vaadin.ApplicationEnvironment;
import com.storedobject.vaadin.FieldCustomizer;
import com.storedobject.vaadin.NoField;
import com.storedobject.vaadin.ObjectFieldCreator;
import com.storedobject.vaadin.View;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasValue;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class ObjectForm<D>
extends AbstractForm<D> {
    private final Map<String, Method> getM = new HashMap<String, Method>();
    private final Map<String, Method> setM = new HashMap<String, Method>();
    private final Map<String, Function<D, ?>> getF = new HashMap();
    private final Map<String, BiConsumer<D, ?>> setF = new HashMap();
    private final Map<String, HasValue<?, ?>> extras = new HashMap();
    private ObjectFieldCreator<D> fCreator;
    private FieldCustomizer fieldCustomizer;
    private static final Method dummyGET = ObjectForm.dummyGET();

    public ObjectForm(Class<D> objectClass) {
        this(objectClass, null);
    }

    public ObjectForm(Class<D> objectClass, HasComponents container) {
        super(objectClass, container);
        this.data.setFieldValueHandler(new FieldHandler());
    }

    @Override
    protected void constructed() {
        if (this.fCreator != null) {
            this.fCreator.close();
            this.fCreator = null;
        }
        super.constructed();
    }

    ObjectFieldCreator<D> getFieldCreator() {
        if (this.fCreator == null) {
            this.fCreator = Objects.requireNonNull(ApplicationEnvironment.get()).getObjectFieldCreator().create(this);
        }
        return this.fCreator;
    }

    public void setMethodHandlerHost(Object host) {
        ((FieldHandler)this.data.getFieldValueHandler()).setHost(host);
    }

    public Class<D> getObjectClass() {
        return this.objectClass;
    }

    public Class<D> getDataClass() {
        return this.objectClass;
    }

    protected void addField(Iterable<String> fieldNames) {
        fieldNames.forEach(xva$0 -> this.addField((String)xva$0));
    }

    protected void addField(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            BiConsumer<D, ?> valueSetter;
            Function<D, ?> valueGetter;
            Method valueSetterM;
            if (!this.isFieldIncluded(fieldName)) continue;
            Method valueGetterM = this.getGetMethodFromHost(fieldName);
            Method method = valueSetterM = valueGetterM == null ? null : this.getSetMethodFromHost(fieldName, valueGetterM);
            if (valueGetterM == null) {
                valueGetter = this.getFieldCreator().getValueGetter(fieldName);
                if (valueGetter != null) {
                    this.getF.put(fieldName, valueGetter);
                }
            } else {
                valueGetter = null;
            }
            if (valueSetterM == null) {
                valueSetter = this.getFieldCreator().getValueSetter(fieldName);
                if (valueSetter != null) {
                    this.setF.put(fieldName, valueSetter);
                    if (valueGetterM != null) {
                        this.getM.put(fieldName, valueGetterM);
                        continue;
                    }
                }
            } else {
                valueSetter = null;
            }
            if (valueGetter != null || valueSetter != null) continue;
            this.addField(fieldName, valueGetterM, valueSetterM);
        }
    }

    protected <V> String addField(HasValue<?, V> field, Function<D, V> valueGetter) {
        return this.addField(field, valueGetter, null);
    }

    protected <V> String addField(HasValue<?, V> field, Function<D, V> valueGetter, BiConsumer<D, V> valueSetter) {
        String fieldName = "_" + ID.newID();
        this.extras.put(fieldName, field);
        if (valueGetter != null) {
            this.getF.put(fieldName, valueGetter);
        }
        if (valueSetter != null) {
            this.setF.put(fieldName, valueSetter);
        }
        return fieldName;
    }

    @Override
    protected void addField(String fieldName, Function<D, ?> valueGetter) {
        this.addField(fieldName, valueGetter, null);
    }

    protected void addField(String fieldName, Function<D, ?> valueGetter, BiConsumer<D, ?> valueSetter) {
        if (!this.isFieldIncluded(fieldName)) {
            return;
        }
        if (this.getM.containsKey(fieldName) || this.getF.containsKey(fieldName)) {
            return;
        }
        if (valueGetter == null && valueSetter == null) {
            this.addField(fieldName, null, (Method)null);
            return;
        }
        if (valueGetter == null) {
            Method m = this.getFieldGetMethod(fieldName);
            if (m == null) {
                return;
            }
            this.getM.put(fieldName, m);
            this.setF.put(fieldName, valueSetter);
            return;
        }
        this.getF.put(fieldName, valueGetter);
        if (valueSetter != null) {
            this.setF.put(fieldName, valueSetter);
            return;
        }
        Method m = this.getFieldGetMethod(fieldName);
        if (m == null) {
            return;
        }
        if ((m = this.getFieldSetMethod(fieldName, m)) != null) {
            this.setM.put(fieldName, m);
        }
    }

    protected void addField(String fieldName, Method getMethod) {
        this.addField(fieldName, getMethod, null);
    }

    protected void addField(String fieldName, Method getMethod, Method setMethod) {
        if (!this.isFieldIncluded(fieldName)) {
            return;
        }
        if (this.getM.containsKey(fieldName) || this.getF.containsKey(fieldName)) {
            return;
        }
        if (getMethod == null) {
            getMethod = this.getFieldGetMethod(fieldName);
        }
        if (getMethod == null) {
            this.getM.put(fieldName, dummyGET);
            return;
        }
        this.getM.put(fieldName, getMethod);
        if (setMethod == null) {
            setMethod = this.getFieldSetMethod(fieldName, getMethod);
        }
        if (setMethod == null) {
            return;
        }
        this.setM.put(fieldName, setMethod);
    }

    private boolean isField(Method m) {
        return m.getAnnotation(NoField.class) == null;
    }

    private Method getGetMethodFromHost(String fieldName) {
        Method m;
        Object host = this.getHost();
        if (host == null) {
            return null;
        }
        if (host instanceof View && "Caption".equals(fieldName)) {
            return null;
        }
        try {
            m = host.getClass().getMethod("get" + fieldName, new Class[0]);
            if (m.getDeclaringClass() == host.getClass() && this.isField(m)) {
                return m;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            m = host.getClass().getMethod("is" + fieldName, new Class[0]);
            if (m.getDeclaringClass() == host.getClass() && this.isField(m)) {
                return m;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private Method getSetMethodFromHost(String fieldName, Method getMethod) {
        Object host = this.getHost();
        if (host == null) {
            return null;
        }
        if (host instanceof View && "Caption".equals(fieldName)) {
            return null;
        }
        Class[] params = new Class[]{getMethod.getReturnType()};
        try {
            Method m = host.getClass().getMethod("set" + fieldName, params);
            if (m.getDeclaringClass() == host.getClass()) {
                return m;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    protected Method getFieldGetMethod(String fieldName) {
        Method m2;
        try {
            m2 = this.checkMethod(((Object)((Object)this)).getClass().getMethod("get" + fieldName, new Class[0]));
            if (m2 != null) {
                return m2;
            }
        }
        catch (NoSuchMethodException m2) {
            // empty catch block
        }
        try {
            m2 = this.checkMethod(((Object)((Object)this)).getClass().getMethod("is" + fieldName, new Class[0]));
            if (m2 != null) {
                return m2;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            return this.objectClass.getMethod("get" + fieldName, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return this.objectClass.getMethod("is" + fieldName, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                return null;
            }
        }
    }

    Method checkMethod(Method m) {
        if (m == null) {
            return null;
        }
        Class<AbstractDataEditor> dc = m.getDeclaringClass();
        return dc == ((Object)((Object)this)).getClass() || dc == AbstractDataEditor.DForm.class || dc.isAssignableFrom(AbstractDataEditor.class) || dc.getName().startsWith("com.vaadin.") ? null : m;
    }

    protected Method getFieldSetMethod(String fieldName, Method getMethod) {
        Class[] params = new Class[]{getMethod.getReturnType()};
        try {
            Method m = this.checkMethod(((Object)((Object)this)).getClass().getMethod("set" + fieldName, params));
            if (m != null) {
                return m;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            return this.objectClass.getMethod("set" + fieldName, params);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    @Override
    protected void generateFieldNames() {
        this.getFieldGetMethods().forEach(m -> {
            String name = this.getFieldCreator().getFieldName((Method)m);
            if (name != null && this.isFieldIncluded(name)) {
                Method hm = this.getGetMethodFromHost(name);
                this.addField(name, hm == null ? m : hm, null);
            }
        });
        Stream<String> additionalNames = this.getFieldCreator().getFieldNames();
        if (additionalNames != null) {
            additionalNames.filter(Objects::nonNull).filter(this::isFieldIncluded).forEach(xva$0 -> this.addField((String)xva$0));
        }
    }

    private Stream<Method> getFieldGetMethods() {
        Stream<Method> stream = this.getFieldCreator().getFieldGetMethods();
        return stream == null ? Arrays.stream(this.objectClass.getMethods()) : stream;
    }

    @Override
    protected final Stream<String> getFieldNames() {
        return Stream.concat(this.getM.keySet().stream(), this.getF.keySet().stream()).filter(n -> n != null && !n.isEmpty()).filter(this::isFieldIncluded).sorted(Comparator.comparingInt(this::getFieldOrder));
    }

    protected int getFieldOrder(String fieldName) {
        return this.getFieldCreator().getFieldOrder(fieldName);
    }

    protected boolean includeField(String fieldName) {
        return true;
    }

    public final boolean isFieldIncluded(String fieldName) {
        return this.includeField.includeField(fieldName) && this.includeField(fieldName);
    }

    private static Method dummyGET() {
        try {
            return Object.class.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    @Override
    protected final HasValue<?, ?> createField(String fieldName) {
        HasValue<?, ?> field;
        if (fieldName.startsWith("_") && (field = this.extras.get(fieldName)) != null) {
            return field;
        }
        Method m = this.getM.get(fieldName);
        if (m == dummyGET) {
            this.getM.remove(fieldName);
            m = null;
        }
        if ((field = super.createField(fieldName)) == null) {
            Class<?> returnType = m == null ? null : m.getReturnType();
            field = this.createField(fieldName, returnType, this.getLabel(fieldName));
        }
        return field;
    }

    @Override
    void customize(String fieldName, HasValue<?, ?> field) {
        this.customizeField(fieldName, field);
        this.getFieldCreator().customizeField(fieldName, field);
        if (this.fieldCustomizer != null) {
            this.fieldCustomizer.customizeField(fieldName, field);
        }
    }

    public void setFieldCustomizer(FieldCustomizer fieldCustomizer) {
        this.fieldCustomizer = fieldCustomizer;
    }

    @Override
    public String getLabel(String fieldName) {
        if (this.getView() instanceof AbstractDataForm) {
            try {
                return ((AbstractDataForm)this.getView()).getLabel(fieldName);
            }
            catch (AbstractDataForm.FieldError fieldError) {
                // empty catch block
            }
        }
        return this.getFieldCreator().getLabel(fieldName);
    }

    protected HasValue<?, ?> createField(String fieldName, Class<?> fieldType, String label) {
        return this.getFieldCreator().createField(fieldName, fieldType, label);
    }

    protected void customizeField(String fieldName, HasValue<?, ?> field) {
    }

    protected boolean handleValueSetError(String fieldName, HasValue<?, ?> field, Object fieldValue, Object objectValue, Throwable error) {
        return true;
    }

    private Object getHost() {
        return ((FieldHandler)this.data.getFieldValueHandler()).host;
    }

    private class FieldHandler
    extends AbstractForm.ValueHandler {
        private Object host;

        private FieldHandler() {
        }

        private void setHost(Object host) {
            this.host = host;
        }

        @Override
        public boolean isBasic() {
            return false;
        }

        @Override
        public boolean canHandle(String fieldName) {
            return ObjectForm.this.getM.containsKey(fieldName) || ObjectForm.this.getF.containsKey(fieldName);
        }

        @Override
        public boolean canSet(String fieldName) {
            return ObjectForm.this.setM.containsKey(fieldName) || ObjectForm.this.setF.containsKey(fieldName);
        }

        @Override
        public Object getValue(String fieldName) {
            Function get = ObjectForm.this.getF.get(fieldName);
            if (get != null) {
                return get.apply(ObjectForm.this.getObject());
            }
            try {
                Method m = ObjectForm.this.getM.get(fieldName);
                if (m == null || m == dummyGET) {
                    return null;
                }
                return m.invoke(this.actOn(m), new Object[0]);
            }
            catch (Throwable error) {
                Application a = Application.get();
                if (a != null) {
                    a.log("Field: " + fieldName, error);
                }
                return null;
            }
        }

        @Override
        public void setValue(String fieldName, Object value) {
            BiConsumer set = ObjectForm.this.setF.get(fieldName);
            if (set != null) {
                try {
                    set.accept(ObjectForm.this.getObject(), value);
                }
                catch (Throwable e) {
                    this.handleValueSetError(fieldName, ObjectForm.this.getField(fieldName), value, this.getValue(fieldName), e);
                }
                return;
            }
            Method m = ObjectForm.this.setM.get(fieldName);
            if (m != null) {
                try {
                    m.invoke(this.actOn(m), value);
                }
                catch (Throwable e) {
                    this.handleValueSetError(fieldName, ObjectForm.this.getField(fieldName), value, this.getValue(fieldName), e);
                }
            }
        }

        private Object actOn(Method m) {
            Class<Object> dc = m.getDeclaringClass();
            if (dc == ObjectForm.this.getObjectClass()) {
                return ObjectForm.this.getObject();
            }
            if (dc == ((Object)((Object)ObjectForm.this)).getClass()) {
                return ObjectForm.this;
            }
            if (this.host != null && dc == this.host.getClass()) {
                return this.host;
            }
            if (dc.isAssignableFrom(ObjectForm.this.getObjectClass())) {
                return ObjectForm.this.getObject();
            }
            if (dc.isAssignableFrom(((Object)((Object)ObjectForm.this)).getClass())) {
                return ObjectForm.this;
            }
            if (this.host != null && dc.isAssignableFrom(this.host.getClass())) {
                return this.host;
            }
            return null;
        }

        private void handleValueSetError(String fieldName, HasValue<?, ?> field, Object fieldValue, Object objectValue, Throwable error) {
            AbstractForm.markError(field);
            if (ObjectForm.this.handleValueSetError(fieldName, field, fieldValue, objectValue, error)) {
                ObjectForm.this.data.setExtraErrors();
            }
        }
    }
}

