/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.ApplicationEnvironment;
import com.storedobject.vaadin.BigDecimalField;
import com.storedobject.vaadin.BooleanField;
import com.storedobject.vaadin.DateField;
import com.storedobject.vaadin.DoubleField;
import com.storedobject.vaadin.IntegerField;
import com.storedobject.vaadin.LegacyDateField;
import com.storedobject.vaadin.LongField;
import com.storedobject.vaadin.ObjectForm;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.textfield.TextField;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;

public interface ObjectFieldCreator<T> {
    default public ObjectFieldCreator<T> create(ObjectForm<T> objectForm) {
        return this;
    }

    default public Stream<Method> getFieldGetMethods() {
        return null;
    }

    default public Method getFieldGetMethod(String fieldName) {
        return null;
    }

    default public Method getFieldSetMethod(String fieldName, Method getMethod) {
        return null;
    }

    default public Stream<String> getFieldNames() {
        return null;
    }

    default public HasValue<?, ?> createField(String fieldName, Class<?> fieldType, String label) {
        if (fieldType == null) {
            return null;
        }
        if (fieldType == String.class) {
            return new TextField(label);
        }
        if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
            return new BooleanField(label);
        }
        if (fieldType == Integer.TYPE || fieldType == Integer.class) {
            return new IntegerField(label);
        }
        if (fieldType == Long.TYPE || fieldType == Long.class) {
            return new LongField(label);
        }
        if (fieldType == Double.TYPE || fieldType == Double.class) {
            return new DoubleField(label);
        }
        if (fieldType == BigDecimal.class) {
            return new BigDecimalField(label);
        }
        if (fieldType == Date.class) {
            return new DateField(label);
        }
        if (fieldType == java.util.Date.class) {
            return new LegacyDateField(label);
        }
        if (fieldType == LocalDate.class) {
            return new DatePicker(label);
        }
        return null;
    }

    default public void customizeField(String fieldName, HasValue<?, ?> field) {
    }

    default public String getFieldName(Method getMethod) {
        String name = getMethod.getName();
        if (name.equals("getClass")) {
            return null;
        }
        if (name.startsWith("get")) {
            return name.substring(3);
        }
        if (name.startsWith("is")) {
            return name.substring(2);
        }
        return null;
    }

    default public Function<T, ?> getValueGetter(String fieldName) {
        return null;
    }

    default public BiConsumer<T, ?> getValueSetter(String fieldName) {
        return null;
    }

    default public int getFieldOrder(String fieldName) {
        return Integer.MAX_VALUE;
    }

    default public String getLabel(String fieldName) {
        return Objects.requireNonNull(ApplicationEnvironment.get()).createLabel(fieldName);
    }

    default public void close() {
    }
}

