/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.ApplicationEnvironment;
import com.storedobject.vaadin.HasColumns;
import com.vaadin.flow.component.grid.ColumnTextAlign;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public interface ObjectColumnCreator<T> {
    default public ObjectColumnCreator<T> create(HasColumns<T> grid) {
        return this;
    }

    default public Stream<String> getColumnNames() {
        return null;
    }

    default public Method getColumnMethod(String columnName) {
        return null;
    }

    default public Function<T, ?> getColumnFunction(String columnName) {
        return null;
    }

    default public int getColumnOrder(String columnName) {
        return Integer.MIN_VALUE;
    }

    default public String getColumnCaption(String columnName) {
        return Objects.requireNonNull(ApplicationEnvironment.get()).createLabel(columnName);
    }

    default public ColumnTextAlign getColumnTextAlign(String columnName, Class<?> valueType) {
        if (valueType != null && (Number.class.isAssignableFrom(valueType) || valueType == Integer.TYPE || valueType == Long.TYPE || valueType == Double.TYPE || valueType == Float.TYPE)) {
            return ColumnTextAlign.END;
        }
        return null;
    }

    default public Class<?> getColumnValueType(String columnName) {
        return null;
    }

    default public void close() {
    }
}

