/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.Application;
import com.storedobject.vaadin.ApplicationMenuItem;
import com.storedobject.vaadin.ApplicationMenuItemGroup;
import com.storedobject.vaadin.ClickHandler;
import com.storedobject.vaadin.Clickable;
import com.storedobject.vaadin.ExecutableView;
import com.storedobject.vaadin.Icon;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@CssImport(value="./so/menu/styles.css")
public class MenuItem
extends Div
implements ApplicationMenuItem {
    final Icon icon;
    int level = 0;
    private final Span caption = new Span();

    public MenuItem(String label, Icon icon, Runnable runnable, boolean closeable) {
        this.icon = icon;
        this.setClassName("so-menu");
        this.setLabel(label);
        if (icon != null) {
            icon.setSize("1.25em");
            icon.setStyle("margin-right", "0.4em");
            this.add(new Component[]{icon});
            icon.getStyle().set("min-width", "1.25em");
        }
        if (runnable != null) {
            new Clickable<MenuItem>((MenuItem)(closeable ? this.caption : this), (ClickHandler & Serializable)e -> Application.get().execute(runnable));
        }
        this.caption.getStyle().set("flex-grow", "100");
        this.add(new Component[]{this.caption});
    }

    public static ApplicationMenuItem create(String menuLabel, String icon, Runnable menuAction) {
        return new MenuItem(menuLabel, MenuItem.createIcon(icon), menuAction, false);
    }

    public static ApplicationMenuItem create(ExecutableView view, String menuLabel, Runnable menuAction) {
        boolean closeable = view.isCloseable();
        Icon icon = MenuItem.createIcon(closeable ? "vaadin:close-circle" : view.getMenuIconName());
        if (closeable) {
            icon.setAttribute("title", "Close");
            new Clickable<Icon>(icon, (ClickHandler & Serializable)e -> view.abort());
        }
        return new MenuItem(menuLabel, icon, menuAction, closeable);
    }

    public static ApplicationMenuItemGroup createGroup(String menuLabel) {
        return new MenuItemGroup(menuLabel);
    }

    private static Icon createIcon(String icon) {
        return new Icon(icon == null ? "vaadin:chevron_circle_right" : icon);
    }

    @Override
    public void hilite() {
        this.setClassName("so-menu-hilite");
    }

    @Override
    public void dehilite() {
        this.setClassName("so-menu-active");
    }

    @Override
    public void setLabel(String caption) {
        this.caption.setText(caption);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled();
    }

    private static class MenuItemGroup
    extends MenuItem
    implements ApplicationMenuItemGroup {
        private boolean plus = true;
        private final List<MenuItem> items = new ArrayList<MenuItem>();

        private MenuItemGroup(String label) {
            this(label, new Icon("vaadin:plus-circle"));
        }

        private MenuItemGroup(String label, Icon icon) {
            super(label, icon, null, false);
            new Clickable<MenuItemGroup>(this, (ClickHandler & Serializable)e -> this.toggle());
        }

        private void toggle() {
            this.plus = !this.plus;
            this.icon.setIcon("vaadin:" + (this.plus ? "plus" : "minus") + "-circle");
            this.items.forEach(mi -> mi.setVisible(!this.plus));
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.items.forEach(mi -> mi.setVisible(!this.plus && this.isVisible()));
        }

        @Override
        public void add(ApplicationMenuItem menuItem) {
            if (!(menuItem instanceof MenuItem)) {
                return;
            }
            MenuItem mi = (MenuItem)menuItem;
            mi.level = this.level + 1;
            int n = 40 + mi.level * 125;
            mi.icon.setStyle("margin-left", n / 100 + "." + n % 100 + "em");
            mi.setVisible(!this.plus && this.isVisible());
            this.items.add(mi);
        }

        @Override
        public void remove(ApplicationMenuItem menuItem) {
            if (!(menuItem instanceof MenuItem)) {
                return;
            }
            this.items.remove(menuItem);
        }
    }
}

