/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.ClickHandler;
import com.storedobject.vaadin.MenuBarItem;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.contextmenu.SubMenu;

public class MenuBar
extends MenuBarItem {
    private final com.vaadin.flow.component.menubar.MenuBar bar = new com.vaadin.flow.component.menubar.MenuBar();

    protected com.vaadin.flow.component.menubar.MenuBar initContent() {
        return this.bar;
    }

    @Override
    public MenuBarItem addMenuItem(String caption, ClickHandler clickHandler) {
        TransferredClickHandler ch = new TransferredClickHandler(clickHandler);
        MenuItem mi = new MenuItem(this.bar.addItem(caption, ClickHandler.convert(ch)), false);
        ch.setAnother((Component)mi);
        return mi;
    }

    @Override
    public MenuBarItem addMenuItem(Component component, ClickHandler clickHandler) {
        TransferredClickHandler ch = new TransferredClickHandler(clickHandler);
        MenuItem mi = new MenuItem(this.bar.addItem(component, ClickHandler.convert(ch)), false);
        ch.setAnother((Component)mi);
        return mi;
    }

    @Override
    public MenuBarItem addMenuItem(String caption) {
        return new MenuItem(this.bar.addItem(caption), true);
    }

    @Override
    public MenuBarItem addMenuItem(Component component) {
        return new MenuItem(this.bar.addItem(component), true);
    }

    @Override
    public void remove(MenuBarItem ... items) {
        if (items != null) {
            for (MenuBarItem item : items) {
                if (!(item instanceof MenuItem)) continue;
                MenuItem mi = (MenuItem)item;
                this.bar.remove(new com.vaadin.flow.component.contextmenu.MenuItem[]{mi.menuItem});
            }
        }
    }

    @Override
    public void removeAll() {
        this.bar.removeAll();
    }

    public void setOpenOnHover(boolean openOnHover) {
        this.bar.setOpenOnHover(openOnHover);
    }

    public boolean isOpenOnHover() {
        return this.bar.isOpenOnHover();
    }

    public com.vaadin.flow.component.menubar.MenuBar getBar() {
        return this.bar;
    }

    private static class TransferredClickHandler
    implements ClickHandler {
        private final ClickHandler clickHandler;
        private Component another;

        private TransferredClickHandler(ClickHandler clickHandler) {
            this.clickHandler = clickHandler;
        }

        void setAnother(Component another) {
            this.another = another;
        }

        @Override
        public void clicked(Component c) {
            if (this.clickHandler != null && this.another != null) {
                this.clickHandler.clicked(this.another);
            }
        }

        @Override
        public void onComponentEvent(ClickEvent<? extends Component> event) {
            if (this.clickHandler != null && this.another != null) {
                this.clickHandler.onComponentEvent(new ClickHandler.ModifiedClickEvent<Component>(event, this.another));
            }
        }
    }

    private static class MenuItem
    extends MenuBarItem {
        private final com.vaadin.flow.component.contextmenu.MenuItem menuItem;
        private final SubMenu subMenu;

        private MenuItem(com.vaadin.flow.component.contextmenu.MenuItem menuItem, boolean forSub) {
            this.menuItem = menuItem;
            this.subMenu = forSub ? (SubMenu)menuItem.getSubMenu() : null;
        }

        protected com.vaadin.flow.component.contextmenu.MenuItem initContent() {
            return this.menuItem;
        }

        @Override
        public MenuBarItem addMenuItem(String caption, ClickHandler clickHandler) {
            if (this.subMenu == null) {
                return null;
            }
            TransferredClickHandler ch = new TransferredClickHandler(clickHandler);
            MenuItem mi = new MenuItem(this.subMenu.addItem(caption, ClickHandler.convert(ch)), false);
            ch.setAnother((Component)mi);
            return mi;
        }

        @Override
        public MenuBarItem addMenuItem(Component component, ClickHandler clickHandler) {
            if (this.subMenu == null) {
                return null;
            }
            TransferredClickHandler ch = new TransferredClickHandler(clickHandler);
            MenuItem mi = new MenuItem(this.subMenu.addItem(component, ClickHandler.convert(ch)), false);
            ch.setAnother((Component)mi);
            return mi;
        }

        @Override
        public MenuBarItem addMenuItem(String caption) {
            if (this.subMenu == null) {
                return null;
            }
            return new MenuItem((com.vaadin.flow.component.contextmenu.MenuItem)this.subMenu.addItem(caption), true);
        }

        @Override
        public MenuBarItem addMenuItem(Component component) {
            if (this.subMenu == null) {
                return null;
            }
            return new MenuItem((com.vaadin.flow.component.contextmenu.MenuItem)this.subMenu.addItem(component), true);
        }

        @Override
        public void remove(MenuBarItem ... items) {
            if (this.subMenu != null) {
                for (MenuBarItem mi : items) {
                    if (!(mi instanceof MenuItem)) continue;
                    MenuItem m = (MenuItem)mi;
                    this.subMenu.remove(new Component[]{m.menuItem});
                }
            }
        }

        @Override
        public void removeAll() {
            if (this.subMenu != null) {
                this.subMenu.removeAll();
            }
        }

        @Override
        public void setCheckable(boolean checkable) {
            if (this.subMenu == null) {
                this.menuItem.setCheckable(checkable);
            }
        }

        @Override
        public boolean isCheckable() {
            return this.subMenu == null && this.menuItem.isCheckable();
        }

        @Override
        public void setChecked(boolean checked) {
            if (this.subMenu == null) {
                this.menuItem.setChecked(checked);
            }
        }

        @Override
        public boolean isChecked() {
            return this.subMenu == null && this.menuItem.isChecked();
        }
    }
}

