/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.helper.ID;
import com.storedobject.vaadin.HasSize;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamRegistration;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinSession;
import java.io.Serializable;
import java.util.ArrayList;

public abstract class Media
extends Component
implements HasSize {
    private final ArrayList<StreamResource> resources = new ArrayList();
    private final ArrayList<StreamRegistration> registrations = new ArrayList();
    private final ArrayList<Element> uriSources = new ArrayList();

    public Media() {
        ID.set((Component)this);
        this.showControls(true);
    }

    public Media(StreamResource ... resources) {
        ID.set((Component)this);
        this.addSource(resources);
        this.showControls(true);
    }

    public Media(String uri, String type) {
        ID.set((Component)this);
        this.addSource(uri, type);
        this.showControls(true);
    }

    private void reload() {
        String id = this.getId().orElse(null);
        if (id != null) {
            UI ui = this.getUI().orElse(null);
            if (ui == null) {
                ui = UI.getCurrent();
            }
            if (ui != null) {
                ui.getPage().executeJs("document.getElementById('" + id + "').load();", new Serializable[0]);
            }
        }
    }

    public void setSource(StreamResource ... resources) {
        this.clear();
        this.addSource(resources);
    }

    public void addSource(StreamResource ... resources) {
        this.registerAll();
        for (StreamResource sr : resources) {
            if (sr == null) continue;
            this.resources.add(sr);
            this.register(sr);
        }
        this.reload();
    }

    public void setSource(String uri, String type) {
        this.clear();
        this.addSource(uri, type);
    }

    public void addSource(String uri, String type) {
        this.registerAll();
        Element s = new Element("source");
        s.setAttribute("src", uri);
        s.setAttribute("type", type);
        this.getElement().appendChild(new Element[]{s});
        this.uriSources.add(s);
        this.reload();
    }

    public void clear() {
        this.registrations.forEach(StreamRegistration::unregister);
        this.registrations.clear();
        this.resources.clear();
        this.getElement().removeAllChildren();
        this.getElement().setText("Media not supported on this browser!");
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.registrations.forEach(StreamRegistration::unregister);
        this.registrations.clear();
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.registerAll();
    }

    private void registerAll() {
        if (!this.registrations.isEmpty()) {
            return;
        }
        this.resources.forEach(this::register);
        this.uriSources.forEach(ur -> this.getElement().appendChild(new Element[]{ur}));
    }

    private void register(StreamResource sr) {
        if (sr == null) {
            return;
        }
        StreamRegistration r = VaadinSession.getCurrent().getResourceRegistry().registerResource((AbstractStreamResource)sr);
        this.registrations.add(r);
        Element s = new Element("source");
        s.setAttribute("src", StreamResourceRegistry.getURI((AbstractStreamResource)sr).toASCIIString());
        s.setAttribute("type", (String)sr.getContentTypeResolver().apply((Object)sr, (Object)VaadinServlet.getCurrent().getServletContext()));
        this.getElement().appendChild(new Element[]{s});
    }

    public void showControls(boolean on) {
        this.getElement().setAttribute("controls", on);
    }
}

