/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.ApplicationEnvironment;
import com.storedobject.vaadin.SpellCheck;
import com.vaadin.flow.component.combobox.ComboBox;
import java.util.Map;

public class MapComboField<T>
extends ComboBox<T>
implements SpellCheck {
    private final Map<T, ?> map;

    public MapComboField(Map<T, ?> map) {
        this(null, map);
    }

    public MapComboField(String label, Map<T, ?> map) {
        this.map = map;
        this.setItems(map.keySet());
        this.setItemLabelGenerator(this::toDisplay);
        if (label != null) {
            this.setLabel(label);
        }
        this.setPlaceholder("Select");
    }

    public void setValue(T value) {
        if (value != null && this.map.get(value) == null) {
            value = null;
        }
        super.setValue(value);
    }

    public void refresh() {
        this.setItems(this.map.keySet());
    }

    private String toDisplay(T key) {
        Object value = this.map.get(key);
        ApplicationEnvironment ae = ApplicationEnvironment.get();
        return ae == null ? (value == null ? "" : value.toString()) : ae.toDisplay(value);
    }

    public Map<T, ?> getMap() {
        return this.map;
    }
}

