/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.DataGrid;
import com.storedobject.vaadin.DataList;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;

public class ListGrid<T>
extends DataGrid<T>
implements List<T> {
    private boolean wrapped;
    private final Refresher refresher = new Refresher();
    private DataList<T> data;

    public ListGrid(Class<T> objectClass) {
        this(objectClass, null, null);
    }

    public ListGrid(Class<T> objectClass, Iterable<String> columns) {
        this(objectClass, null, columns);
    }

    public ListGrid(Class<T> objectClass, List<T> data) {
        this(objectClass, data, null);
    }

    public ListGrid(Class<T> objectClass, List<T> data, Iterable<String> columns) {
        super(objectClass, columns);
        this.setData(data);
    }

    public List<T> getData() {
        return this.wrapped ? this.data.getData() : this.data;
    }

    public void setData(List<T> data) {
        DataList<T> list;
        if (data == null) {
            data = new DataList();
        }
        if (data instanceof DataList) {
            list = (DataList<T>)data;
            this.wrapped = false;
        } else {
            list = new DataList<T>(data);
            this.wrapped = true;
        }
        this.data = list;
        super.setItems(this.createListDataProvider(this.data));
        this.refresher.change();
    }

    protected ListDataProvider<T> createListDataProvider(DataList<T> data) {
        return new ListDataProvider(data);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.refresher.set();
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.refresher.remove();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean contains(Object item) {
        return this.data.contains(item);
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.data.iterator();
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    @Nonnull
    public <T1> T1[] toArray(@Nonnull T1[] a) {
        return this.data.toArray(a);
    }

    @Override
    public boolean add(T item) {
        return this.data.add(item);
    }

    @Override
    public boolean remove(Object item) {
        return this.data.remove(item);
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> collection) {
        return this.data.containsAll(collection);
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends T> collection) {
        return this.data.addAll(collection);
    }

    @Override
    public boolean addAll(int index, @Nonnull Collection<? extends T> collection) {
        return this.data.addAll(index, collection);
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> collection) {
        return this.data.removeAll(collection);
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        return this.data.removeIf(filter);
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> collection) {
        return this.data.retainAll(collection);
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        this.data.replaceAll(operator);
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        this.data.sort(comparator);
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public T get(int index) {
        return this.data.get(index);
    }

    @Override
    public T set(int index, T item) {
        return this.data.set(index, item);
    }

    @Override
    public void add(int index, T item) {
        this.data.add(index, item);
    }

    @Override
    public T remove(int index) {
        return this.data.remove(index);
    }

    @Override
    public int indexOf(Object item) {
        return this.data.indexOf(item);
    }

    @Override
    public int lastIndexOf(Object item) {
        return this.data.lastIndexOf(item);
    }

    @Override
    @Nonnull
    public ListIterator<T> listIterator() {
        return this.data.listIterator();
    }

    @Override
    @Nonnull
    public ListIterator<T> listIterator(int index) {
        return this.data.listIterator(index);
    }

    @Override
    @Nonnull
    public List<T> subList(int fromIndex, int toIndex) {
        return this.data.subList(fromIndex, toIndex);
    }

    public ListDataProvider<T> getDataProvider() {
        return (ListDataProvider)super.getDataProvider();
    }

    public void setViewFilter(Predicate<T> filter) {
        if (filter == null) {
            this.getDataProvider().setFilter(null);
            return;
        }
        this.getDataProvider().setFilter(filter::test);
    }

    public void addViewFilter(Predicate<T> filter) {
        if (filter == null) {
            return;
        }
        SerializablePredicate old = this.getDataProvider().getFilter();
        if (old == null) {
            this.setViewFilter(filter);
            return;
        }
        this.setViewFilter(arg_0 -> ListGrid.lambda$addViewFilter$0((Predicate)old, filter, arg_0));
    }

    public void clearViewFilters() {
        this.setViewFilter(null);
    }

    private static /* synthetic */ boolean lambda$addViewFilter$0(Predicate old, Predicate filter, Object item) {
        return old.test(item) && filter.test(item);
    }

    private class Refresher
    implements DataList.RefreshListener<T> {
        private Registration registration;

        private Refresher() {
        }

        void change() {
            if (this.registration != null) {
                this.registration.remove();
                this.registration = ListGrid.this.data.addRefreshListener(this);
                this.refresh();
            }
        }

        void set() {
            if (this.registration == null) {
                this.registration = ListGrid.this.data.addRefreshListener(this);
                this.refresh();
            }
        }

        void remove() {
            if (this.registration != null) {
                this.registration.remove();
                this.registration = null;
            }
        }

        @Override
        public void refresh() {
            ListGrid.this.refresh();
        }

        @Override
        public void refresh(T item) {
            ListGrid.this.refresh(item);
        }
    }
}

