/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.SpellCheck;
import com.storedobject.vaadin.ValueRequired;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.select.data.SelectListDataView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ListField<T>
extends Select<T>
implements SpellCheck,
ValueRequired {
    private SelectListDataView<T> view;

    public ListField(Collection<T> items) {
        this(null, items);
    }

    public ListField(String label, Collection<T> items) {
        this.setItems(items);
        this.setLabel(label);
        this.setRequired(true);
    }

    public int getIndex(T value) {
        for (int i = 0; i < this.view.getItemCount(); ++i) {
            if (!this.view.getItem(i).equals(value)) continue;
            return i;
        }
        return this.view.getItemCount() != 0 && this.isRequired() ? 0 : -1;
    }

    public void setIndex(int index) {
        if (index < 0 || index >= this.view.getItemCount()) {
            return;
        }
        this.setValue(this.view.getItem(index));
    }

    public T getValue(int index) {
        Object item;
        if (index >= 0 && index < this.view.getItemCount() && (item = this.view.getItem(index)) != null) {
            return (T)item;
        }
        return (T)(this.isRequired() && this.view.getItemCount() != 0 ? this.view.getItem(0) : null);
    }

    public SelectListDataView<T> setItems(Collection<T> items) {
        this.view = (SelectListDataView)super.setItems(items);
        return this.view;
    }

    public SelectListDataView<T> setItems(Iterable<T> items) {
        ArrayList<T> list = new ArrayList<T>();
        for (T item : items) {
            list.add(item);
        }
        return this.setItems((Collection<T>)list);
    }

    @SafeVarargs
    public final SelectListDataView<T> setItems(T ... items) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, items);
        return this.setItems((Collection<T>)list);
    }

    public void setItem(int index, T item) {
        List items = this.view.getItems().collect(Collectors.toList());
        if (index >= 0 && index < items.size()) {
            items.set(index, item);
            this.setItems((Collection<T>)items);
        }
    }

    public SelectListDataView<T> removeItems(Collection<T> items) {
        this.view.removeItems(items);
        return this.view;
    }

    @SafeVarargs
    public final SelectListDataView<T> removeItems(T ... items) {
        return this.removeItems((Collection<T>)Arrays.asList(items));
    }

    public SelectListDataView<T> removeItems(Stream<T> items) {
        items.forEach(arg_0 -> this.view.removeItem(arg_0));
        return this.view;
    }

    public SelectListDataView<T> addItems(Collection<T> items) {
        this.view.addItems(items);
        return this.view;
    }

    @SafeVarargs
    public final SelectListDataView<T> addItems(T ... items) {
        if (items != null) {
            for (T item : items) {
                if (item == null) continue;
                this.view.addItem(item);
            }
        }
        return this.view;
    }

    public SelectListDataView<T> addItems(Stream<T> items) {
        items.filter(Objects::nonNull).forEach(arg_0 -> this.view.addItem(arg_0));
        return this.view;
    }

    @Override
    public void setRequired(boolean required) {
        this.getElement().setProperty("required", required);
    }

    @Override
    public boolean isRequired() {
        return this.getElement().getProperty("required", false);
    }
}

