/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.Box;
import com.storedobject.vaadin.CustomField;
import com.storedobject.vaadin.util.ElementClick;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.data.binder.HasItems;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LabelField<T>
extends CustomField<T>
implements HasItems<T> {
    private Span container = new Span();
    private List<T> items;
    private int index = -1;
    private ItemLabelGenerator<T> labelGenerator;

    public LabelField(List<T> items) {
        this(null, items);
    }

    public LabelField(String label, List<T> items) {
        super(items.get(0));
        this.add(new Component[]{this.container});
        Box b = new Box((Component)this.container);
        b.grey();
        b.setStyle("cursor", "pointer");
        b.setBorderWidth(0);
        b.setHiliteOnHover(true);
        ElementClick click = new ElementClick((Component)this);
        click.addClickListener((ComponentEventListener<ClickEvent<Component>>)(ComponentEventListener & Serializable)e -> this.setIndex(this.index + 1, true));
        this.setItems(items);
        this.setLabel(label);
        this.setIndex(0);
    }

    public void setItems(Collection<T> items) {
        this.items = new ArrayList<T>(items);
        Object newValue = this.getValue();
        if (newValue == null && this.index < 0) {
            this.index = 0;
            newValue = this.generateModelValue();
        }
        this.container.setText(this.toString(newValue));
        this.updateValue();
    }

    public void setIndex(int newIndex) {
        this.setIndex(newIndex, false);
    }

    private void setIndex(int newIndex, boolean fromClient) {
        int oldIndex;
        if (this.index == newIndex) {
            return;
        }
        if (this.items == null || this.items.isEmpty()) {
            return;
        }
        if (newIndex >= this.items.size()) {
            newIndex = 0;
        }
        if (newIndex != (oldIndex = this.index)) {
            this.index = newIndex;
            this.container.setText(this.toString(this.items.get(newIndex)));
            this.setModelValue(this.generateModelValue(), fromClient);
        }
    }

    public int getIndex() {
        if (this.index < 0 || this.items == null || this.items.isEmpty()) {
            this.index = -1;
            return this.index;
        }
        if (this.index >= this.items.size()) {
            this.index = this.items.size() % this.index;
        }
        return this.index;
    }

    public T getValue(int index) {
        if (index < 0 || this.items == null || this.items.isEmpty() || index >= this.items.size()) {
            return null;
        }
        return this.items.get(index);
    }

    public int getIndex(T value) {
        if (value == null || this.items == null || this.items.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).equals(value)) continue;
            return i;
        }
        return -1;
    }

    private String toString(T value) {
        return this.labelGenerator != null ? this.labelGenerator.apply(value) : (value == null ? "" : value.toString());
    }

    protected T generateModelValue() {
        if (this.getIndex() < 0) {
            return null;
        }
        return this.items.get(this.index);
    }

    protected void setPresentationValue(T value) {
        if (this.items == null || this.items.isEmpty()) {
            return;
        }
        this.setIndex(this.items.indexOf(value));
    }

    public void setItemLabelGenerator(ItemLabelGenerator<T> labelGenerator) {
        this.labelGenerator = labelGenerator;
    }
}

