/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.HomeView;
import com.storedobject.vaadin.Image;
import com.storedobject.vaadin.View;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.server.AbstractStreamResource;

public class ImageView
extends View
implements HomeView {
    private final Image image;

    public ImageView() {
        this((Image)null);
    }

    public ImageView(String url) {
        this((Image)null);
        this.setSource(url);
    }

    public ImageView(AbstractStreamResource resource) {
        this((Image)null);
        this.setSource(resource);
    }

    public ImageView(Image image) {
        super("I");
        this.image = image == null ? new Image((String)null) : image;
        this.image.setSizeFull();
        this.image.getStyle().set("object-fit", "fill");
    }

    @Override
    protected void initUI() {
        Component c = this.getImageComponent(this.image);
        this.setComponent((Component)(c == null ? this.image : c));
    }

    @Override
    public void decorateComponent() {
        super.decorateComponent();
        this.getComponent().getElement().getStyle().set("padding", "0px");
    }

    public void setSource(String source) {
        this.image.setSource(source);
    }

    public void setSource(AbstractStreamResource source) {
        this.image.setSource(source);
    }

    public Component getImageComponent(Image image) {
        Div div = new Div(new Component[]{image});
        div.setSizeFull();
        div.getStyle().set("overflow", "hidden");
        return div;
    }
}

