/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.Box;
import com.storedobject.vaadin.ClickHandler;
import com.storedobject.vaadin.HasBadgeStyle;
import com.storedobject.vaadin.Icon;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.icon.VaadinIcon;

public class ImageButton
extends Icon
implements HasBadgeStyle,
HasEnabled {
    private boolean enabled = true;
    private String color = null;
    private String disabledColor = "var(--lumo-disabled-text-color)";

    public ImageButton(String iconName, ClickHandler clickHandler) {
        super(iconName);
        this.init(clickHandler, iconName);
    }

    public ImageButton(VaadinIcon icon, ClickHandler clickHandler) {
        this(null, icon, clickHandler);
    }

    public ImageButton(String title, VaadinIcon icon, ClickHandler clickHandler) {
        super(icon);
        this.init(clickHandler, title);
    }

    public ImageButton(String title, String iconName, ClickHandler clickHandler) {
        super(iconName);
        this.init(clickHandler, title);
    }

    private void init(ClickHandler clickHandler, String title) {
        this.getElement().getStyle().set("cursor", "pointer");
        this.addClickHandler(clickHandler);
        if (title != null) {
            this.setAttribute("title", title);
        }
        this.setColor(this.color);
    }

    public ImageButton withSize(int sizeInPixels) {
        this.setSize(sizeInPixels <= 0 ? null : sizeInPixels + "px");
        return this;
    }

    @Override
    public ImageButton asSmall() {
        return (ImageButton)HasBadgeStyle.super.asSmall();
    }

    public ImageButton withBox() {
        return this.withBox(25);
    }

    public ImageButton withBox(int sizeInPixels) {
        if (sizeInPixels < 5) {
            sizeInPixels = 25;
        }
        Box box = new Box((Component)this.icon);
        this.setSize(sizeInPixels + "px");
        box.alignSizing();
        box.grey();
        return this;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            super.setColor(this.color);
        } else {
            super.setColor(this.disabledColor);
        }
    }

    @Override
    public void setColor(String color) {
        this.color = color;
        if (this.enabled) {
            super.setColor(color);
        }
    }

    public void setDisabledColor(String color) {
        this.disabledColor = color;
        if (!this.enabled) {
            super.setColor(color);
        }
    }
}

