/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.PaintedImageResource;
import com.storedobject.vaadin.ResourceSupport;
import com.storedobject.vaadin.ResourcedComponent;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.server.AbstractStreamResource;
import java.awt.Graphics2D;
import java.util.function.Consumer;

public class Image
extends com.vaadin.flow.component.html.Image
implements ResourcedComponent {
    private static final String NOT_LOADED = "Image not loaded";
    private static final String NO_IMAGE = "No image";
    private final ResourceSupport resourceSupport = new ResourceSupport(this);

    public Image() {
    }

    public Image(String url) {
        this.setSource(url);
    }

    public Image(AbstractStreamResource resource) {
        this.setSource(resource);
    }

    public void setSource(String source) {
        this.resourceSupport.clear();
        if (source == null) {
            this.setSource((AbstractStreamResource)new PaintedImageResource((Consumer<Graphics2D>)null));
            this.setAlt(NO_IMAGE);
        } else {
            super.setSrc(source);
            this.setAlt(NOT_LOADED);
        }
    }

    public void setSrc(String src) {
        this.setSource(src);
    }

    @Override
    public void setSource(AbstractStreamResource source) {
        if (source == null) {
            this.setSource((String)null);
        } else {
            this.resourceSupport.register(source);
            this.setAlt(NOT_LOADED);
            super.setSrc(source);
        }
    }

    public void setSrc(AbstractStreamResource source) {
        this.setSource(source);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.resourceSupport.register();
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.resourceSupport.unregister();
    }

    public void clear() {
        this.setSource((String)null);
    }
}

