/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.ClickHandler;
import com.storedobject.vaadin.HasIcon;
import com.storedobject.vaadin.HasSquareElement;
import com.storedobject.vaadin.HasStyle;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Icon
extends Composite<Component>
implements HasStyle,
HasIcon,
HasSquareElement,
ClickNotifier<Icon> {
    private static final Map<String, Class<? extends IconInterface>> iconCollections = new HashMap<String, Class<? extends IconInterface>>();
    final IconInterface icon;

    public Icon(VaadinIcon icon) {
        this(Icon.create(icon));
    }

    public Icon(String icon) {
        this(Icon.create(icon));
    }

    private Icon(IconInterface icon) {
        this.icon = icon;
    }

    protected Component initContent() {
        return (Component)this.icon;
    }

    @Override
    public Element getInternalElement() {
        return this.icon.getElement();
    }

    @Override
    public void setIcon(VaadinIcon icon) {
        this.setIcon(HasIcon.getIconName(icon));
    }

    @Override
    public void setIcon(String icon) {
        if (icon == null || icon.isBlank()) {
            return;
        }
        icon = HasIcon.getIconName(icon);
        Class<? extends IconInterface> iClass = iconCollections.get(icon.substring(0, icon.lastIndexOf(58)));
        if (this.icon.getClass() == iClass) {
            this.icon.setIcon(icon);
        }
    }

    private static IconInterface create(VaadinIcon icon) {
        VIcon ii = new VIcon();
        ii.setIcon(icon);
        return ii;
    }

    private static IconInterface create(String icon) {
        if (icon == null || icon.isBlank()) {
            return new EmptyIcon();
        }
        if ((icon = HasIcon.getIconName(icon)) == null || icon.isBlank()) {
            return new EmptyIcon();
        }
        Class<? extends IconInterface> iClass = iconCollections.get(icon.substring(0, icon.lastIndexOf(58)));
        if (iClass == null) {
            return new EmptyIcon();
        }
        IconInterface ii = Icon.create(iClass);
        if (ii instanceof VIcon) {
            String name = icon.substring(icon.lastIndexOf(58) + 1).toUpperCase().replace('-', '_');
            boolean found = false;
            for (VaadinIcon vi : VaadinIcon.values()) {
                if (!vi.name().equals(name)) continue;
                found = true;
                break;
            }
            if (!found) {
                return new EmptyIcon();
            }
        }
        ii.setIcon(icon);
        return ii;
    }

    private static IconInterface create(Class<?> klass) {
        if (klass == IIcon.class) {
            return new IIcon();
        }
        return new VIcon();
    }

    @Override
    public String getIcon() {
        return this.icon.getIcon();
    }

    @Override
    public void setSize(String size) {
        HasSquareElement.super.setSize(size);
        this.icon.setSize(size);
    }

    @Override
    public String getSize() {
        return this.icon.getSize();
    }

    public void setWidth(String width) {
        HasSquareElement.super.setWidth(width);
        this.icon.setWidth(width);
    }

    public void setMinWidth(String minWidth) {
        HasSquareElement.super.setMinWidth(minWidth);
        this.icon.setMinWidth(minWidth);
    }

    public void setMaxWidth(String maxWidth) {
        HasSquareElement.super.setMaxWidth(maxWidth);
        this.icon.setMaxWidth(maxWidth);
    }

    public String getWidth() {
        return this.icon.getWidth();
    }

    public String getMinWidth() {
        return this.icon.getMinWidth();
    }

    public String getMaxWidth() {
        return this.icon.getMaxWidth();
    }

    public void setHeight(String height) {
        HasSquareElement.super.setHeight(height);
        this.icon.setHeight(height);
    }

    public void setMinHeight(String minHeight) {
        HasSquareElement.super.setMinHeight(minHeight);
        this.icon.setMinHeight(minHeight);
    }

    public void setMaxHeight(String maxHeight) {
        HasSquareElement.super.setMaxHeight(maxHeight);
        this.icon.setMaxHeight(maxHeight);
    }

    public String getHeight() {
        return this.icon.getHeight();
    }

    public String getMinHeight() {
        return this.icon.getMinHeight();
    }

    public String getMaxHeight() {
        return this.icon.getMaxHeight();
    }

    public void setColor(String color) {
        this.icon.setColor(color);
    }

    public String getColor() {
        return this.icon.getColor();
    }

    @Override
    public void setStyle(String name, String value) {
        this.icon.getStyle().set(name, value);
    }

    @Override
    public void setAttribute(String name, String value) {
        this.icon.setAttribute(name, value);
    }

    public Registration addClickHandler(ClickHandler clickHandler) {
        ClickNotifier clickNotifier = (ClickNotifier)this.icon;
        return clickNotifier.addClickListener((ComponentEventListener & Serializable)e -> {
            ClickHandler.ModifiedClickEvent ce = new ClickHandler.ModifiedClickEvent(e, (Component)this);
            clickHandler.onComponentEvent(ce);
        });
    }

    public Registration addClickListener(ComponentEventListener<ClickEvent<Icon>> listener) {
        ClickNotifier clickNotifier = (ClickNotifier)this.icon;
        return clickNotifier.addClickListener((ComponentEventListener & Serializable)e -> {
            ClickHandler.ModifiedClickEvent ce = new ClickHandler.ModifiedClickEvent(e, (Component)this);
            listener.onComponentEvent(ce);
        });
    }

    static {
        iconCollections.put("vaadin", VIcon.class);
        iconCollections.put("icons", IIcon.class);
        iconCollections.put("av", IIcon.class);
        iconCollections.put("communication", IIcon.class);
        iconCollections.put("device", IIcon.class);
        iconCollections.put("editor", IIcon.class);
        iconCollections.put("hardware", IIcon.class);
        iconCollections.put("image", IIcon.class);
        iconCollections.put("maps", IIcon.class);
        iconCollections.put("notification", IIcon.class);
        iconCollections.put("social", IIcon.class);
        iconCollections.put("places", IIcon.class);
    }

    private static interface IconInterface
    extends HasStyle,
    HasIcon,
    HasSquareElement {
        default public void setColor(String color) {
            if (color == null) {
                this.getStyle().remove("fill");
            } else {
                this.getStyle().set("fill", color);
            }
        }

        default public String getColor() {
            return this.getStyle().get("fill");
        }

        @Override
        default public Element getInternalElement() {
            return HasStyle.super.getInternalElement();
        }
    }

    private static class VIcon
    extends com.vaadin.flow.component.icon.Icon
    implements IconInterface {
        private VIcon() {
        }
    }

    private static class EmptyIcon
    extends Span
    implements IconInterface {
        private EmptyIcon() {
        }
    }

    @NpmPackage(value="@polymer/iron-icons", version="^3.0.1")
    @JsModule.Container(value={@JsModule(value="@polymer/iron-icons/iron-icons.js"), @JsModule(value="@polymer/iron-icons/av-icons.js"), @JsModule(value="@polymer/iron-icons/communication-icons.js"), @JsModule(value="@polymer/iron-icons/device-icons.js"), @JsModule(value="@polymer/iron-icons/editor-icons.js"), @JsModule(value="@polymer/iron-icons/hardware-icons.js"), @JsModule(value="@polymer/iron-icons/image-icons.js"), @JsModule(value="@polymer/iron-icons/maps-icons.js"), @JsModule(value="@polymer/iron-icons/notification-icons.js"), @JsModule(value="@polymer/iron-icons/social-icons.js"), @JsModule(value="@polymer/iron-icons/places-icons.js")})
    @Tag(value="iron-icon")
    private static class IIcon
    extends Component
    implements IconInterface,
    ClickNotifier<IIcon> {
        private IIcon() {
        }
    }
}

