/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.ApplicationEnvironment;
import com.storedobject.vaadin.HasElement;
import com.vaadin.flow.component.icon.VaadinIcon;

public interface HasIcon
extends HasElement {
    default public void setIcon(String icon) {
        if (HasIcon.getIconName(icon) == null) {
            this.getElement().removeAttribute("icon");
            return;
        }
        this.getElement().setAttribute("icon", HasIcon.getIconName(icon));
    }

    default public void setIcon(VaadinIcon icon) {
        this.setIcon(HasIcon.getIconName(icon));
    }

    default public String getIcon() {
        return this.getElement().getAttribute("icon");
    }

    public static String getIconName(String icon) {
        if (icon == null || ((String)icon).trim().isEmpty()) {
            return null;
        }
        if (!((String)icon).contains(":")) {
            ApplicationEnvironment ae = ApplicationEnvironment.get();
            if (ae != null) {
                icon = ae.getIconName((String)icon);
            }
            if (icon == null) {
                return null;
            }
            if (!((String)icon).contains(":")) {
                icon = "vaadin:" + (String)icon;
            }
        }
        return ((String)icon).trim().toLowerCase().replace('_', '-');
    }

    public static String getIconName(VaadinIcon icon) {
        return "vaadin:" + icon.name().toLowerCase().replace('_', '-');
    }
}

