/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.AbstractDataForm;
import com.storedobject.vaadin.Application;
import com.storedobject.vaadin.ApplicationEnvironment;
import com.storedobject.vaadin.ApplicationMenuItem;
import com.storedobject.vaadin.ButtonIcon;
import com.storedobject.vaadin.ClickHandler;
import com.storedobject.vaadin.ConstructedListener;
import com.storedobject.vaadin.ExecutableView;
import com.storedobject.vaadin.GridColumnDetail;
import com.storedobject.vaadin.GridRow;
import com.storedobject.vaadin.HTMLGenerator;
import com.storedobject.vaadin.ItemSelectedListener;
import com.storedobject.vaadin.ItemsSelectedListener;
import com.storedobject.vaadin.ObjectColumnCreator;
import com.storedobject.vaadin.View;
import com.storedobject.vaadin.Window;
import com.storedobject.vaadin.WindowDecorator;
import com.storedobject.vaadin.WrappedView;
import com.storedobject.vaadin.util.SupportWindowMode;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.contextmenu.ContextMenu;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.grid.ColumnTextAlign;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.treegrid.TreeGrid;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public interface HasColumns<T>
extends ExecutableView,
SupportWindowMode {
    public Registration addConstructedListener(ConstructedListener var1);

    public Stream<ConstructedListener> streamConstructedListeners();

    public void clearConstructedListeners();

    default public void constructed() {
    }

    default public Component createHeader() {
        return null;
    }

    default public void createHeaders() {
    }

    default public void createFooters() {
    }

    default public GridRow prependHeader() {
        return GridRow.createHeader(this.getSOGrid().grid, false);
    }

    default public GridRow appendHeader() {
        return GridRow.createHeader(this.getSOGrid().grid, true);
    }

    default public GridRow prependFooter() {
        return GridRow.createFooter(this.getSOGrid().grid, false);
    }

    default public GridRow appendFooter() {
        return GridRow.createFooter(this.getSOGrid().grid, true);
    }

    default public Stream<String> getColumnNames() {
        return null;
    }

    default public void customizeColumn(String columnName, Grid.Column<T> column) {
    }

    default public View createView() {
        return null;
    }

    default public Window createDecoratedWindow(View view) {
        this.getSOGrid().grid.setWidth("80vw");
        this.getSOGrid().grid.setHeight("80vh");
        return new Window(new Component[]{new WindowDecorator(view, new Component[0]), (Component)this});
    }

    default public void compact() {
        this.getSOGrid().compact();
    }

    default public T getObjectRendered() {
        return this.getSOGrid().objectRendered;
    }

    default public void render(T object) {
    }

    default public T getObjectUnwrapped() {
        return this.getSOGrid().objectUnwrapped;
    }

    default public T unwrap(T object) {
        return object;
    }

    default public void setColumnResizable(String columnName, boolean resizable) {
        this.getSOGrid().setColumnResizable(columnName, resizable);
    }

    default public boolean isColumnResizable(String columnName) {
        return this.getSOGrid().isColumnResizable(columnName);
    }

    default public void setColumnVisible(String columnName, boolean visible) {
        this.getSOGrid().setColumnVisible(columnName, visible);
    }

    default public boolean isColumnVisible(String columnName) {
        return this.getSOGrid().isColumnVisible(columnName);
    }

    default public void setColumnFrozen(String columnName, boolean frozen) {
        this.getSOGrid().setColumnFrozen(columnName, frozen);
    }

    default public boolean isColumnFrozen(String columnName) {
        return this.getSOGrid().isColumnFrozen(columnName);
    }

    default public ButtonIcon getConfigureButton() {
        return this.getSOGrid().getConfigureButton();
    }

    default public int getRelativeColumnWidth(String columnName) {
        return -1;
    }

    default public String getFixedColumnWidth(String columnName) {
        return null;
    }

    default public int getColumnCount() {
        return this.getSOGrid().getColumnCount();
    }

    default public Class<T> getDataClass() {
        return this.getSOGrid().objectClass;
    }

    default public void refresh() {
        this.getSOGrid().grid.getDataProvider().refreshAll();
    }

    default public void refresh(T item) {
        this.getSOGrid().grid.getDataProvider().refreshItem(item);
    }

    default public void refresh(T item, boolean refreshChildren) {
        this.getSOGrid().grid.getDataProvider().refreshItem(item, refreshChildren);
    }

    default public GridColumnDetail<T> getColumnDetail(String columnName) {
        return this.getSOGrid().columnDetails.get(columnName);
    }

    default public Function<T, ?> getColumnFunction(String columnName) {
        return null;
    }

    default public String getColumnMethodName(String columnName) {
        return columnName;
    }

    default public boolean createColumn(String columnName) {
        return this.getSOGrid().createColumn(columnName);
    }

    default public boolean createColumn(String columnName, Function<T, ?> ... functions) {
        return this.getSOGrid().createColumn(columnName, null, functions);
    }

    default public <C extends Component> boolean createComponentColumn(String columnName, Function<T, C> componentProvider) {
        return this.createColumn(columnName, (Renderer<T>)new ComponentRenderer(componentProvider::apply));
    }

    default public boolean createHTMLColumn(String columnName, Function<T, ?> htmlFunction) {
        return this.getSOGrid().createColumn(columnName, true, null, htmlFunction);
    }

    default public boolean createColumn(String columnName, String template, Function<T, ?> ... functions) {
        return this.getSOGrid().createColumn(columnName, template, functions);
    }

    default public boolean createColumn(String columnName, Method method) {
        return this.getSOGrid().createColumn(columnName, method);
    }

    default public boolean createColumn(String columnName, Renderer<T> renderer) {
        return this.getSOGrid().createColumn(columnName, renderer);
    }

    default public String getColumnTemplate(String columnName) {
        return null;
    }

    default public void customizeRenderer(String columnName, LitRenderer<T> renderer) {
    }

    default public int getColumnOrder(String columnName) {
        throw AbstractDataForm.FIELD_ERROR;
    }

    default public boolean includeColumn(String columnName) {
        throw AbstractDataForm.FIELD_ERROR;
    }

    default public boolean isColumnSortable(String columnName) {
        return true;
    }

    default public Comparator<T> getColumnSorter(String columnName) {
        return null;
    }

    default public boolean ignoreCaseForColumnSorting(String columnName) {
        return true;
    }

    default public ColumnTextAlign getTextAlign(String columnName) {
        return null;
    }

    default public Component getColumnHeaderComponent(String columnName) {
        return null;
    }

    default public String getColumnCaption(String columnName) {
        return null;
    }

    default public int getDefinedColumnCount() {
        SOGrid<T> g = this.getSOGrid();
        return g.renderers == null ? g.getColumnCount() : g.renderers.size();
    }

    default public void setMethodHandlerHost(Object host) {
        this.getSOGrid().methodHandlerHost = host;
    }

    @Override
    default public View getView(boolean create) {
        return this.getSOGrid().getView(create);
    }

    @Override
    default public String getCaption() {
        return this.getSOGrid().caption == null || this.getSOGrid().caption.trim().isEmpty() ? Objects.requireNonNull(ApplicationEnvironment.get()).createLabel(this.getSOGrid().objectClass) : this.getSOGrid().caption;
    }

    @Override
    default public void setCaption(String caption) {
        this.getSOGrid().caption = caption;
        ExecutableView.super.setCaption(caption);
    }

    default public ApplicationMenuItem getMenuItem() {
        return this.getSOGrid().view == null ? null : this.getSOGrid().view.getMenuItem();
    }

    default public void configure() {
        this.getSOGrid().configure();
    }

    default public void select(Iterable<T> items) {
        this.getSOGrid().select(items);
    }

    default public void select(Iterator<T> items) {
        this.getSOGrid().select(items);
    }

    default public void deselect(Iterable<T> items) {
        this.getSOGrid().deselect(items);
    }

    default public void deselect(Iterator<T> items) {
        this.getSOGrid().deselect(items);
    }

    default public T getSelected() {
        return this.getSOGrid().getSelected();
    }

    default public Grid.Column<T> getColumn(String columnName) {
        return this.getSOGrid().getColumnByKey(columnName);
    }

    @Override
    default public <A extends Application> A getApplication() {
        return (A)this.getSOGrid().getApplication();
    }

    default public boolean executing() {
        View v = this.getSOGrid().view;
        return v != null && v.executing();
    }

    default public Grid.Column<T> createHierarchyColumn(String columnName, ValueProvider<T, ?> valueProvider) {
        return null;
    }

    default public Grid.Column<T> createHTMLHierarchyColumn(String columnName, Function<T, ?> htmlFunction) {
        return null;
    }

    @Override
    default public void clearAlerts() {
        Application a;
        ExecutableView.super.clearAlerts();
        View v = this.getSOGrid().getView(false);
        if (v == null && (a = Application.get()) != null) {
            v = a.getActiveView();
        }
        if (v != null) {
            Application.clearAlerts(v);
        }
    }

    public SOGrid<T> getSOGrid();

    default public void addItemSelectedListener(ItemSelectedListener<T> itemSelectedListener) {
        List<ItemSelectedListener<T>> itemSelectedListeners = this.getSOGrid().getItemSelectedListeners();
        if (itemSelectedListeners == null) {
            return;
        }
        itemSelectedListeners.add(itemSelectedListener);
    }

    default public void addItemsSelectedListener(ItemsSelectedListener<T> itemsSelectedListener) {
        this.addItemSelectedListener(itemsSelectedListener);
    }

    default public void removeItemSelectedListener(ItemSelectedListener<T> itemSelectedListener) {
        if (this.getSOGrid().itemSelectedListeners != null) {
            this.getSOGrid().itemSelectedListeners.remove(itemSelectedListener);
        }
    }

    default public GridSortOrder<T> sortOrder(String columnName) {
        return this.sortOrder(columnName, true);
    }

    default public GridSortOrder<T> sortOrder(String columnName, boolean ascending) {
        Grid.Column<T> column;
        Grid.Column<T> column2 = column = columnName == null ? null : this.getSOGrid().getColumnByKey(columnName);
        return column == null ? null : new GridSortOrder(column, ascending ? SortDirection.ASCENDING : SortDirection.DESCENDING);
    }

    default public void sort(GridSortOrder<T> ... sortOrders) {
        if (sortOrders != null) {
            ArrayList<GridSortOrder<T>> sortOrderList = new ArrayList<GridSortOrder<T>>();
            for (GridSortOrder<T> gso : sortOrders) {
                if (gso == null) continue;
                sortOrderList.add(gso);
            }
            if (!sortOrderList.isEmpty()) {
                this.getSOGrid().grid.sort(sortOrderList);
            }
        }
    }

    default public void sort(String ... columnNames) {
        if (columnNames != null && columnNames.length > 0) {
            GridSortOrder[] sortOrders = new GridSortOrder[columnNames.length];
            for (int i = 0; i < columnNames.length; ++i) {
                sortOrders[i] = this.sortOrder(columnNames[i]);
            }
            this.sort(sortOrders);
        }
    }

    default public Component getViewComponent() {
        return this.getSOGrid().grid;
    }

    default public Stream<String> getRenderedColumnNames() {
        return this.getSOGrid().renderedColumns.stream();
    }

    public static class SOGrid<T> {
        private final Grid<T> grid;
        private final HasColumns<T> hc;
        private final Class<T> objectClass;
        private final Map<String, GridColumnDetail<T>> columnDetails = new HashMap<String, GridColumnDetail<T>>();
        private Map<String, Renderer<T>> renderers = new HashMap<String, Renderer<T>>();
        private Map<String, Boolean> columnResizable = new HashMap<String, Boolean>();
        private Map<String, Boolean> columnVisible = new HashMap<String, Boolean>();
        private Map<String, Boolean> columnFrozen = new HashMap<String, Boolean>();
        private Map<String, ValueProvider<T, Comparable>> columnComparators1 = new HashMap<String, ValueProvider<T, Comparable>>();
        private Map<String, Comparator<T>> columnComparators2 = new HashMap<String, Comparator<T>>();
        private Map<String, Integer> columnOrders = new HashMap<String, Integer>();
        private Object methodHandlerHost;
        private int paramId = 0;
        private ButtonIcon configure;
        private ColumnToggleContextMenu configureMenu;
        private ObjectColumnCreator<T> columnCreator;
        private Iterable<String> columns;
        private String caption;
        private boolean allowColumnReordering = true;
        private T objectRendered;
        private T objectUnwrapped;
        private View view;
        private String treeColumnName = "_$_";
        private Application application;
        private List<ItemSelectedListener<T>> itemSelectedListeners;
        private final List<String> renderedColumns = new ArrayList<String>();

        public SOGrid(Grid<T> grid, Class<T> objectClass, Iterable<String> columns) {
            this.grid = grid;
            if (grid instanceof TreeGrid) {
                this.treeColumnName = null;
            }
            this.hc = grid instanceof HasColumns ? (HasColumns)grid : null;
            this.objectClass = objectClass;
            this.columns = columns;
            grid.addAttachListener((ComponentEventListener & Serializable)e -> this.init());
            grid.getElement().getClassList().add((Object)"so-grid");
            grid.setSizeFull();
            this.getApplication();
        }

        private void constructed() {
            Grid<T> grid;
            if (this.configure != null && this.configureMenu == null) {
                this.configure();
            }
            if ((grid = this.grid) instanceof HasColumns) {
                HasColumns hc = (HasColumns)grid;
                hc.constructed();
                hc.streamConstructedListeners().forEach(cl -> cl.constructed(this.grid));
                hc.clearConstructedListeners();
            }
        }

        private void init() {
            if (this.renderers == null) {
                return;
            }
            if (this.columns != null) {
                this.columns.forEach(n -> {
                    this.renderedColumns.add((String)n);
                    n = this.trimCaption((String)n);
                    if (this.includeColumn((String)n)) {
                        this.createColumn((String)n);
                    } else {
                        this.renderedColumns.removeLast();
                    }
                });
            } else {
                Stream<String> columnNames = this.getColumnNames();
                if (columnNames != null) {
                    columnNames.filter(n -> {
                        this.renderedColumns.add((String)n);
                        return true;
                    }).map(this::trimCaption).filter(n -> {
                        if (this.includeColumn((String)n)) {
                            return true;
                        }
                        this.renderedColumns.removeLast();
                        return false;
                    }).forEach(this::createColumn);
                } else {
                    this.generateColumns();
                }
            }
            this.renderers.keySet().stream().filter(this::includeColumn).sorted(Comparator.comparingInt(this::getColumnOrder)).forEach(this::constructColumn);
            this.columns = null;
            this.renderers = null;
            this.columnOrders = null;
            this.columnResizable = null;
            this.columnVisible = null;
            this.columnFrozen = null;
            this.columnComparators1 = null;
            this.columnComparators2 = null;
            this.grid.getElement().setAttribute("theme", this.getDefaultThemes());
            if (this.grid instanceof HasColumns && ((HasColumns)this.grid).getColumnCount() > 0) {
                this.hc.createHeaders();
                Component component = this.hc.createHeader();
                if (component != null) {
                    this.hc.prependHeader().join(new String[0]).setComponent(component);
                }
                this.hc.createFooters();
            }
            if (this.columnCreator != null) {
                this.columnCreator.close();
                this.columnCreator = null;
            }
            this.grid.setColumnReorderingAllowed(this.allowColumnReordering);
            this.constructed();
        }

        private GridColumnDetail<T> cd(String columnName) {
            return this.columnDetails.computeIfAbsent(columnName, k -> new GridColumnDetail());
        }

        private String trimCaption(String columnName) {
            int p = columnName.toLowerCase().lastIndexOf(" as ");
            if (p < 0) {
                return columnName;
            }
            String cn = columnName.substring(0, p).trim();
            this.cd(cn).setCaption(columnName.substring(p + 4));
            return cn;
        }

        private void compact() {
            this.grid.getElement().setAttribute("theme", "compact " + this.getDefaultThemes());
        }

        protected String getDefaultThemes() {
            return "row-stripes wrap-cell-content";
        }

        private Application getApplication() {
            if (this.application == null) {
                this.application = Application.get();
            }
            return this.application;
        }

        private void setRO(T object) {
            if (object == this.objectRendered) {
                return;
            }
            this.objectRendered = object;
            this.hc.render(object);
            this.objectUnwrapped = this.hc.unwrap(this.objectRendered);
        }

        private ObjectColumnCreator<T> cc() {
            if (this.columnCreator == null) {
                this.columnCreator = Objects.requireNonNull(ApplicationEnvironment.get()).getObjectColumnCreator().create(this.hc);
            }
            return this.columnCreator;
        }

        public boolean isColumnReorderingAllowed() {
            return this.allowColumnReordering;
        }

        public void setColumnReorderingAllowed(boolean allowColumnReordering) {
            this.allowColumnReordering = allowColumnReordering;
        }

        private void setColumnResizable(String columnName, boolean resizable) {
            if (this.renderers == null) {
                Grid.Column<T> c = this.getColumnByKey(columnName);
                if (c != null) {
                    c.setResizable(resizable);
                }
                return;
            }
            this.columnResizable.put(columnName, resizable);
        }

        private boolean isColumnResizable(String columnName) {
            if (this.renderers == null) {
                Grid.Column<T> c = this.getColumnByKey(columnName);
                if (c != null) {
                    return c.isResizable();
                }
                return false;
            }
            Boolean v = this.columnResizable.get(columnName);
            return v != null && v != false;
        }

        private void setColumnVisible(String columnName, boolean visible) {
            if (this.renderers == null) {
                Grid.Column<T> c = this.getColumnByKey(columnName);
                if (c != null) {
                    c.setVisible(visible);
                }
                return;
            }
            this.columnVisible.put(columnName, visible);
        }

        private boolean isColumnVisible(String columnName) {
            if (this.renderers == null) {
                Grid.Column<T> c = this.getColumnByKey(columnName);
                if (c != null) {
                    return c.isVisible();
                }
                return false;
            }
            Boolean v = this.columnVisible.get(columnName);
            return v != null && v != false;
        }

        private void setColumnFrozen(String columnName, boolean frozen) {
            if (this.renderers == null) {
                Grid.Column<T> c = this.getColumnByKey(columnName);
                if (c != null) {
                    c.setFrozen(frozen);
                }
                return;
            }
            this.columnFrozen.put(columnName, frozen);
        }

        private boolean isColumnFrozen(String columnName) {
            if (this.renderers == null) {
                Grid.Column<T> c = this.getColumnByKey(columnName);
                if (c != null) {
                    return c.isFrozen();
                }
                return false;
            }
            Boolean v = this.columnFrozen.get(columnName);
            return v != null && v != false;
        }

        private ButtonIcon getConfigureButton() {
            if (this.configure == null) {
                this.configure = new ButtonIcon("icons:settings", (ClickHandler & Serializable)e -> this.configure());
                this.configure.setPlaceholder("Configure columns");
            }
            return this.configure;
        }

        private void configure() {
            this.grid.recalculateColumnWidths();
            if (this.configureMenu == null) {
                this.configureMenu = new ColumnToggleContextMenu();
                this.getColumns().forEach(c -> this.configureMenu.addColumn(c));
            } else {
                this.getColumns().forEach(c -> {
                    MenuItem mi;
                    GridColumnDetail<T> cd = this.cd(c.getKey());
                    if (cd != null && (mi = cd.getContextMenu()) != null) {
                        mi.setChecked(c.isVisible());
                    }
                });
            }
        }

        public List<Grid.Column<T>> getColumns() {
            this.init();
            return this.grid.getColumns();
        }

        public Grid.Column<T> getColumnByKey(String columnKey) {
            this.init();
            return this.grid.getColumnByKey(columnKey);
        }

        private int getColumnCount() {
            return this.getColumns().size();
        }

        private String getColumnName(Method getMethod) {
            String name = getMethod.getName();
            if (name.equals("getClass")) {
                return null;
            }
            if (name.startsWith("get")) {
                return name.substring(3);
            }
            if (name.startsWith("is")) {
                return name.substring(2);
            }
            return null;
        }

        private void generateColumns() {
            for (Method m : this.objectClass.getMethods()) {
                String name;
                if (Modifier.isStatic(m.getModifiers()) || m.getParameterTypes().length > 0 || (name = this.getColumnName(m)) == null || !this.includeColumn(name)) continue;
                this.renderedColumns.add(name);
                this.createColumn(name, m);
            }
        }

        private Stream<String> getColumnNames() {
            Stream<String> names = null;
            if (this.grid instanceof HasColumns) {
                names = ((HasColumns)this.grid).getColumnNames();
            }
            return names == null ? this.cc().getColumnNames() : names;
        }

        private Method getColumnMethod(String columnName) {
            Method m = this.cc().getColumnMethod(columnName);
            if (m != null) {
                return m;
            }
            try {
                return this.objectClass.getMethod("get" + columnName, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    return this.objectClass.getMethod("is" + columnName, new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    return null;
                }
            }
        }

        private Method getOutsideMethod(String columnName) {
            columnName = this.getColumnMethodName(columnName);
            for (Class<T> objectClass = this.objectClass; objectClass != null; objectClass = objectClass.getSuperclass()) {
                Method m = this.getOutsideMethod(columnName, objectClass);
                if (m != null) {
                    return m;
                }
                if (objectClass == Object.class) break;
            }
            return null;
        }

        private Method getOutsideMethod(String columnName, Class<?> objectClass) {
            boolean methodName;
            Class[] params = new Class[]{objectClass};
            boolean bl = methodName = Character.isLowerCase(((String)columnName).charAt(0)) && !((String)columnName).equals(((String)columnName).toLowerCase());
            if (this.methodHandlerHost != null) {
                if (methodName) {
                    try {
                        return this.methodHandlerHost.getClass().getMethod((String)columnName, params);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                try {
                    return this.methodHandlerHost.getClass().getMethod("get" + (String)columnName, params);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        return this.methodHandlerHost.getClass().getMethod("is" + (String)columnName, params);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        // empty catch block
                    }
                }
            }
            if (methodName) {
                try {
                    return this.grid.getClass().getMethod((String)columnName, params);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            try {
                return this.grid.getClass().getMethod("get" + (String)columnName, params);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    return this.grid.getClass().getMethod("is" + (String)columnName, params);
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    if (((String)columnName).equals(((String)columnName).toLowerCase()) && !((String)(columnName = Character.toUpperCase(((String)columnName).charAt(0)) + ((String)columnName).substring(1))).equals(((String)columnName).toLowerCase())) {
                        return this.getOutsideMethod((String)columnName, objectClass);
                    }
                    return null;
                }
            }
        }

        private String getColumnMethodName(String columnName) {
            String m = this.hc.getColumnMethodName(columnName);
            return m == null || m.isEmpty() ? columnName : m;
        }

        private Function<T, ?> getColumnFunction(String columnName) {
            Function<T, ?> f = this.hc.getColumnFunction(columnName);
            return f == null ? this.cc().getColumnFunction(columnName) : f;
        }

        private boolean createColumn(String columnName) {
            Renderer<T> r;
            if (columnName == null || columnName.equals(this.treeColumnName)) {
                return false;
            }
            if (this.renderers != null && this.renderers.containsKey(columnName)) {
                return false;
            }
            Method m = this.getOutsideMethod(columnName);
            Function<Object, Object> function = null;
            if (m != null) {
                if (this.createTreeColumn(columnName, m)) {
                    return true;
                }
                function = this.getMethodFunction(columnName, m);
            }
            if (function == null && (function = this.getColumnFunction(columnName)) == null) {
                m = this.getColumnMethod(columnName);
                function = m == null ? item -> "?" : this.getMethodFunction(columnName, m);
            }
            if (this.createTreeColumn(columnName, function)) {
                return true;
            }
            Class<?> type = this.getColumnValueType(columnName);
            boolean html = type != null && (type == String.class || HTMLGenerator.class.isAssignableFrom(type));
            Renderer<T> renderer = r = html ? this.renderer(columnName, function) : this.renderer(columnName, this.hc.getColumnTemplate(columnName), false, function);
            if (this.renderers == null) {
                this.constructColumn(columnName, r);
            } else {
                this.renderers.put(columnName, r);
            }
            return true;
        }

        @SafeVarargs
        private boolean createColumn(String columnName, String template, Function<T, ?> ... functions) {
            return this.createColumn(columnName, false, template, functions);
        }

        @SafeVarargs
        private boolean createColumn(String columnName, boolean html, String template, Function<T, ?> ... functions) {
            Renderer<T> r;
            if (functions == null || functions.length == 0) {
                return this.createColumn(columnName);
            }
            if (functions.length == 1 && this.createTreeColumn(columnName, functions[0])) {
                return true;
            }
            if (!html) {
                Class<?> type = this.getColumnValueType(columnName);
                boolean bl = html = type != null && (type == String.class || HTMLGenerator.class.isAssignableFrom(type));
            }
            if (!html && template == null && this.hc != null) {
                template = this.hc.getColumnTemplate(columnName);
            }
            Renderer<T> renderer = r = html ? this.renderer(columnName, functions[0]) : this.renderer(columnName, template, false, functions);
            if (this.renderers == null) {
                this.constructColumn(columnName, r);
            } else {
                this.renderers.put(columnName, r);
            }
            return true;
        }

        private boolean createColumn(String columnName, Method method) {
            if (method == null) {
                return this.createColumn(columnName);
            }
            if (this.createTreeColumn(columnName, method)) {
                return true;
            }
            return this.createColumn(columnName, null, this.getMethodFunction(columnName, method));
        }

        private boolean createColumn(String columnName, Renderer<T> renderer) {
            if (renderer == null) {
                return this.createColumn(columnName);
            }
            if (this.renderers == null) {
                this.constructColumn(columnName, renderer);
            } else {
                this.renderers.put(columnName, renderer);
            }
            return true;
        }

        @SafeVarargs
        private Renderer<T> renderer(String columnName, String template, boolean html, Function<T, ?> ... functions) {
            int i2;
            boolean sortable;
            this.cd(columnName).setValueFunction(functions);
            boolean bl = sortable = this.hc != null && this.hc.isColumnSortable(columnName);
            if (template == null) {
                StringBuilder s = new StringBuilder();
                IntStream.range(0, functions.length - 1).forEach(i -> s.append('<').append(i).append('>').append("<br/>"));
                s.append('<').append(functions.length).append('>');
                template = s.toString();
            }
            int[] ids = new int[functions.length];
            for (i2 = 0; i2 < ids.length; ++i2) {
                ids[i2] = ++this.paramId;
            }
            for (i2 = 0; i2 < ids.length; ++i2) {
                template = template.replace("<" + (i2 + 1) + ">", "${item.so" + ids[i2] + "}");
            }
            LitRenderer r = LitRenderer.of((String)template);
            if (this.getColumnValueType(columnName) == String.class) {
                function = functions[0];
                r.withProperty("so" + ids[0], (ValueProvider & Serializable)o -> {
                    this.setRO(o);
                    o = this.objectUnwrapped;
                    return HTMLGenerator.encodeHTML((String)function.apply(o)).replace("\n", "<br>");
                });
            } else {
                for (i2 = 0; i2 < ids.length; ++i2) {
                    function = functions[i2];
                    r.withProperty("so" + ids[i2], (ValueProvider & Serializable)o -> {
                        this.setRO(o);
                        o = this.objectUnwrapped;
                        Object v = function.apply(o);
                        if (v == null && this.grid instanceof TreeGrid) {
                            v = "";
                        }
                        return Objects.requireNonNull(ApplicationEnvironment.get()).toDisplay(v);
                    });
                }
            }
            if (!html && this.hc != null) {
                this.hc.customizeRenderer(columnName, r);
            }
            if (sortable) {
                Comparator<T> columnSorter = this.hc.getColumnSorter(columnName);
                if (columnSorter != null) {
                    this.columnComparators2.put(columnName, columnSorter);
                    return r;
                }
                Function<T, ?> compareFunction = functions[0];
                ValueProvider & Serializable valueProvider = (ValueProvider & Serializable)o -> {
                    this.setRO(o);
                    o = this.objectUnwrapped;
                    Object v = compareFunction.apply(o);
                    if (!(v instanceof Comparable)) {
                        ApplicationEnvironment ae = ApplicationEnvironment.get();
                        v = ae == null ? v.toString() : ae.toDisplay(v);
                    }
                    if (v instanceof String && this.hc.ignoreCaseForColumnSorting(columnName)) {
                        v = ((String)v).toLowerCase();
                    }
                    return (Comparable)v;
                };
                this.columnComparators1.put(columnName, valueProvider);
            }
            return r;
        }

        private Renderer<T> renderer(String columnName, Function<T, ?> htmlFunction) {
            return this.renderer(columnName, "<span .innerHTML=\"<1>\"></span>", true, htmlFunction);
        }

        void treeBuilt(String columnName) {
            this.treeColumnName = columnName;
        }

        boolean treeCreated() {
            return this.treeColumnName != null;
        }

        private boolean createTreeColumn(String columnName, Method m) {
            if (this.treeCreated() || m == null) {
                return false;
            }
            if (this.hc != null) {
                Function<T, ?> function = this.wrap(this.getMethodFunction(columnName, m));
                Grid.Column<T> c = HTMLGenerator.class.isAssignableFrom(m.getReturnType()) ? this.hc.createHTMLHierarchyColumn(columnName, function) : this.hc.createHierarchyColumn(columnName, function::apply);
                if (c != null && !this.hc.isColumnSortable(columnName)) {
                    c.setSortable(false);
                }
                return c != null;
            }
            return false;
        }

        private boolean createTreeColumn(String columnName, Function<T, ?> function) {
            if (this.treeCreated() || function == null) {
                return false;
            }
            if (this.hc != null) {
                function = this.wrap(function);
                Grid.Column<T> c = this.hc.createHierarchyColumn(columnName, function::apply);
                if (c != null && !this.hc.isColumnSortable(columnName)) {
                    c.setSortable(false);
                }
                return c != null;
            }
            return true;
        }

        private Function<T, ?> wrap(Function<T, ?> function) {
            return item -> {
                this.setRO(item);
                return function.apply(this.objectUnwrapped);
            };
        }

        private Function<T, ?> getMethodFunction(String columnName, Method method) {
            this.cd(columnName).setValueType(method.getReturnType());
            method.setAccessible(true);
            if (this.methodHandlerHost != null && method.getDeclaringClass().isAssignableFrom(this.methodHandlerHost.getClass())) {
                return t -> {
                    try {
                        return method.invoke(this.methodHandlerHost, t);
                    }
                    catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                        return null;
                    }
                };
            }
            if (method.getDeclaringClass().isAssignableFrom(this.grid.getClass())) {
                return t -> {
                    try {
                        return method.invoke(this.grid, t);
                    }
                    catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                        return null;
                    }
                };
            }
            return t -> {
                try {
                    return method.invoke(t, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    return null;
                }
            };
        }

        private void constructColumn(String columnName) {
            this.constructColumn(columnName, this.renderers.get(columnName));
        }

        private void constructColumn(String columnName, Renderer<T> renderer) {
            this.constructColumn(columnName, renderer, this.columnComparators1 == null ? null : this.columnComparators1.get(columnName), this.columnComparators2.get(columnName));
        }

        private void constructColumn(String columnName, Renderer<T> renderer, ValueProvider<T, Comparable> valueProviderForComparator, Comparator<T> comparator) {
            this.acceptColumn(this.constructColumn(columnName, this.grid, renderer, valueProviderForComparator, comparator), columnName);
        }

        protected Grid.Column<T> constructColumn(String columnName, Grid<T> grid, Renderer<T> renderer, ValueProvider<T, Comparable> valueProviderForComparator, Comparator<T> comparator) {
            if (valueProviderForComparator != null || comparator != null) {
                Grid.Column column = grid.addColumn(renderer).setSortProperty(new String[]{columnName});
                if (valueProviderForComparator != null) {
                    column.setComparator(valueProviderForComparator);
                } else {
                    column.setComparator(comparator);
                }
                return column;
            }
            return grid.addColumn(renderer);
        }

        public void acceptColumn(Grid.Column<T> column, String columnName) {
            String w;
            Boolean v;
            Boolean r;
            column.setKey(columnName);
            this.cd(columnName).setColumn(column);
            Component h = this.hc.getColumnHeaderComponent(columnName);
            if (h == null) {
                column.setHeader(this.getHeader(columnName));
            } else {
                column.setHeader(h);
            }
            if (this.columnResizable != null && (r = this.columnResizable.get(columnName)) != null) {
                column.setResizable(r.booleanValue());
            }
            if (this.columnVisible != null && (v = this.columnVisible.get(columnName)) != null) {
                column.setVisible(v.booleanValue());
            }
            column.setTextAlign(this.getTextAlign(columnName));
            column.setAutoWidth(true);
            column.setResizable(true);
            int rw = this.hc.getRelativeColumnWidth(columnName);
            if (rw >= 0) {
                column.setFlexGrow(rw);
            }
            if ((w = this.hc.getFixedColumnWidth(columnName)) != null) {
                column.setAutoWidth(false).setWidth(w).setFlexGrow(0);
            }
            this.customizeColumn(columnName, column);
        }

        private void customizeColumn(String columnName, Grid.Column<T> column) {
            if (this.hc != null) {
                this.hc.customizeColumn(columnName, column);
            }
        }

        private int getColumnOrderCustom(String columnName) {
            try {
                if (this.hc != null) {
                    return this.hc.getColumnOrder(columnName);
                }
            }
            catch (AbstractDataForm.FieldError fieldError) {
                // empty catch block
            }
            return this.cc().getColumnOrder(columnName);
        }

        private int getColumnOrder(String columnName) {
            Integer o;
            if (this.columnOrders != null && (o = this.columnOrders.get(columnName)) != null) {
                return o;
            }
            int order = this.getColumnOrderCustom(columnName);
            if (order == Integer.MIN_VALUE && this.columns != null) {
                order = 0;
                for (String name : this.columns) {
                    if (this.trimCaption(name).equals(columnName)) break;
                    ++order;
                }
            }
            if (this.columnOrders != null) {
                this.columnOrders.put(columnName, order);
            }
            return order;
        }

        private boolean includeColumn(String columnName) {
            try {
                return this.hc.includeColumn(columnName);
            }
            catch (AbstractDataForm.FieldError fieldError) {
                return true;
            }
        }

        private ColumnTextAlign getTextAlign(String columnName) {
            ColumnTextAlign a = this.hc.getTextAlign(columnName);
            if (a == null) {
                Class<?> type = this.getColumnValueType(columnName);
                if (type == null) {
                    type = this.cc().getColumnValueType(columnName);
                }
                a = this.cc().getColumnTextAlign(columnName, type);
            }
            return a == null ? ColumnTextAlign.START : a;
        }

        private Class<?> getColumnValueType(String columnName) {
            Class<Object> type = this.cd(columnName).getValueType();
            if (type == null) {
                type = this.cc().getColumnValueType(columnName);
            }
            if (type == null) {
                type = Object.class;
            }
            this.cd(columnName).setValueType(type);
            return type;
        }

        private String getHeader(String columnName) {
            String h = this.cd(columnName).getCaption();
            if (h != null) {
                return h;
            }
            h = this.hc.getColumnCaption(columnName);
            if (h == null) {
                h = this.cc().getColumnCaption(columnName);
            }
            this.cd(columnName).setCaption(h);
            return h;
        }

        private View getView(boolean create) {
            if (this.view == null && create && this.hc != null) {
                this.view = this.hc.createView();
            }
            if (this.view == null && create) {
                this.view = new WrappedView(this.hc == null ? this.grid : this.hc.getViewComponent(), this.hc != null ? this.hc.getCaption() : "Data View");
            }
            if (this.view != null) {
                this.view.setCreatedBy(this.hc);
            }
            return this.view;
        }

        private void select(Iterable<T> items) {
            items.forEach(arg_0 -> this.grid.select(arg_0));
        }

        private void select(Iterator<T> items) {
            items.forEachRemaining(arg_0 -> this.grid.deselect(arg_0));
        }

        private void deselect(Iterable<T> items) {
            items.forEach(arg_0 -> this.grid.select(arg_0));
        }

        private void deselect(Iterator<T> items) {
            items.forEachRemaining(arg_0 -> this.grid.deselect(arg_0));
        }

        private T getSelected() {
            Set set = this.grid.getSelectedItems();
            if (set == null || set.size() > 1) {
                return null;
            }
            return set.stream().findAny().orElse(null);
        }

        public boolean rendered() {
            return this.renderers == null;
        }

        private List<ItemSelectedListener<T>> getItemSelectedListeners() {
            if (this.itemSelectedListeners == null) {
                this.itemSelectedListeners = new ArrayList<ItemSelectedListener<T>>();
                this.grid.addSelectionListener((SelectionListener & Serializable)e -> this.selected(e.getAllSelectedItems()));
            }
            return this.itemSelectedListeners;
        }

        private void selected(Set<T> selection) {
            if (this.itemSelectedListeners == null || this.itemSelectedListeners.isEmpty()) {
                return;
            }
            this.itemSelectedListeners.forEach(isl -> {
                if (isl instanceof ItemsSelectedListener) {
                    ((ItemsSelectedListener)isl).itemsSelected((Component)this.grid, selection);
                } else {
                    isl.itemSelected((Component)this.grid, selection.stream().findAny().orElse(null));
                }
            });
        }

        private class ColumnToggleContextMenu
        extends ContextMenu {
            ColumnToggleContextMenu() {
                super((Component)SOGrid.this.configure);
                this.setOpenOnClick(true);
            }

            void addColumn(Grid.Column<T> column) {
                GridColumnDetail columnDetail = SOGrid.this.columnDetails.get(column.getKey());
                if (columnDetail == null) {
                    return;
                }
                MenuItem menuItem = this.addItem(columnDetail.getLabel(), (ComponentEventListener & Serializable)e -> {
                    if (e.isFromClient()) {
                        MenuItem mi = (MenuItem)e.getSource();
                        boolean checked = mi.isChecked();
                        if (checked == column.isVisible()) {
                            return;
                        }
                        column.setVisible(checked);
                    }
                });
                columnDetail.setContextMenu(menuItem);
                menuItem.setCheckable(true);
                menuItem.setChecked(column.isVisible());
            }
        }
    }
}

