/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.Application;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.ColumnTextAlign;
import com.vaadin.flow.component.grid.FooterRow;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class GridRow {
    private final Grid<?> grid;
    private final Object row;

    private GridRow(Grid<?> grid, Object row) {
        this.grid = grid;
        this.row = row;
    }

    static GridRow createHeader(Grid<?> grid, boolean append) {
        return new GridHeaderRow(grid, append);
    }

    static GridRow createFooter(Grid<?> grid, boolean append) {
        return new GridFooterRow(grid, append);
    }

    public Cell join(int startintgIndex) {
        return this.join(startintgIndex, Integer.MAX_VALUE);
    }

    public Cell join(int startintgIndex, int endingIndex) {
        ArrayList<String> names = new ArrayList<String>();
        this.getCells().skip(startintgIndex).limit(endingIndex - startintgIndex).forEach(c -> names.add(c.name));
        return this.join(names);
    }

    public Cell join(Collection<String> names) {
        if (names == null || names.isEmpty()) {
            return this.join((String[])null);
        }
        String[] colNames = new String[names.size()];
        names.toArray(colNames);
        return this.join(colNames);
    }

    /*
     * Unable to fully structure code
     */
    public Cell join(String ... names) {
        if (names != null && names.length == 1) {
            return this.getCell(names[0]);
        }
        try {
            cells = new ArrayList<Cell>();
            if (names == null) ** GOTO lbl10
            if (names.length == 0) {
lbl10:
                // 2 sources

                this.getCells().forEach((Consumer<Cell>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lcom/storedobject/vaadin/GridRow$Cell;)V)(cells));
                if (cells.size() == 1) {
                    return this.getCell(((Cell)cells.get((int)0)).name);
                }
            } else {
                for (String name : names) {
                    cell = this.getCell(name);
                    if (cell == null) {
                        return null;
                    }
                    cells.add(cell);
                }
            }
            if (this.row instanceof HeaderRow) {
                hcells = cells.stream().map((Function<Cell, HeaderRow.HeaderCell>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$join$1(com.storedobject.vaadin.GridRow$Cell ), (Lcom/storedobject/vaadin/GridRow$Cell;)Lcom/vaadin/flow/component/grid/HeaderRow$HeaderCell;)()).collect(Collectors.toList());
                ((HeaderRow)this.row).join(hcells);
            } else {
                fcells = cells.stream().map((Function<Cell, FooterRow.FooterCell>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$join$2(com.storedobject.vaadin.GridRow$Cell ), (Lcom/storedobject/vaadin/GridRow$Cell;)Lcom/vaadin/flow/component/grid/FooterRow$FooterCell;)()).collect(Collectors.toList());
                ((FooterRow)this.row).join(fcells);
            }
            return names == null || names.length == 0 ? (Cell)this.getCells().findAny().orElse(null) : this.getCell(names[0]);
        }
        catch (Throwable error) {
            a = Application.get();
            if (a != null) {
                a.log(error);
            }
            return null;
        }
    }

    public Cell joinCells(Cell ... cells) {
        if (cells != null && cells.length == 1) {
            return this.getCell(cells[0].name);
        }
        if (cells == null) {
            return this.join(new String[0]);
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Cell c : cells) {
            names.add(c.name);
        }
        return this.join(names);
    }

    public Cell getCell(String name) {
        Object cell = this.getCell(this.grid.getColumnByKey(name));
        return cell == null ? null : new Cell(cell, name);
    }

    private Object getCell(Grid.Column<?> column) {
        if (column == null || column.isFrozen()) {
            return null;
        }
        return this.row instanceof HeaderRow ? ((HeaderRow)this.row).getCell(column) : ((FooterRow)this.row).getCell(column);
    }

    public Stream<Cell> getCells() {
        ArrayList<Grid.Column> columns = new ArrayList<Grid.Column>();
        Object prev = null;
        for (Object column : this.grid.getColumns()) {
            Object cell = this.getCell((Grid.Column)column);
            if (cell == null || cell == prev) continue;
            prev = cell;
            columns.add((Grid.Column)column);
        }
        return columns.stream().map(c -> new Cell(this.getCell((Grid.Column<?>)c), c.getKey()));
    }

    private static /* synthetic */ FooterRow.FooterCell lambda$join$2(Cell c) {
        return (FooterRow.FooterCell)c.cell;
    }

    private static /* synthetic */ HeaderRow.HeaderCell lambda$join$1(Cell c) {
        return (HeaderRow.HeaderCell)c.cell;
    }

    private static class GridHeaderRow
    extends GridRow {
        public GridHeaderRow(Grid<?> grid, boolean append) {
            super(grid, append ? grid.appendHeaderRow() : grid.prependHeaderRow());
        }
    }

    private static class GridFooterRow
    extends GridRow {
        public GridFooterRow(Grid<?> grid, boolean append) {
            super(grid, append ? grid.appendFooterRow() : grid.prependFooterRow());
        }
    }

    public static class Cell {
        private final String name;
        private final Object cell;

        private Cell(Object cell, String name) {
            this.cell = cell;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Cell setText(String text) {
            if (this.cell instanceof HeaderRow.HeaderCell) {
                ((HeaderRow.HeaderCell)this.cell).setText(text);
            } else {
                ((FooterRow.FooterCell)this.cell).setText(text);
            }
            return this;
        }

        public Cell setText(String text, ColumnTextAlign textAlign) {
            if (textAlign == null || textAlign.equals((Object)ColumnTextAlign.START)) {
                return this.setText(text);
            }
            Div div = new Div(new Component[]{new Span(text)});
            div.getStyle().set("text-align", textAlign.toString());
            div.setSizeFull();
            return this.setComponent((Component)div);
        }

        public Cell setComponent(Component component) {
            if (this.cell instanceof HeaderRow.HeaderCell) {
                ((HeaderRow.HeaderCell)this.cell).setComponent(component);
            } else {
                ((FooterRow.FooterCell)this.cell).setComponent(component);
            }
            return this;
        }
    }
}

