/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.CSSGrid;
import com.vaadin.flow.component.Tag;

@Tag(value="div")
public class GridLayout
extends CSSGrid {
    public GridLayout(int numberOfColumns) {
        this.setColumns(numberOfColumns);
    }

    public GridLayout(int ... columnSizes) {
        this.setColumnSizes(columnSizes);
    }

    public GridLayout(String ... columnSizes) {
        this.setColumnSizes(columnSizes);
    }

    /*
     * WARNING - void declaration
     */
    public void setColumnSizes(String ... sizes) {
        if (sizes == null || sizes.length == 0) {
            return;
        }
        StringBuilder s = new StringBuilder();
        for (String string : sizes) {
            void var6_6;
            if (s.length() > 0) {
                s.append(' ');
            }
            if (string != null) {
                try {
                    if (Integer.parseInt(string) > 0) {
                        String string2 = string + "fr";
                    } else {
                        Object var6_9 = null;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            s.append((String)(var6_6 == null || var6_6.isEmpty() ? "auto" : var6_6));
        }
        this.style("grid-template-columns", s.toString());
    }

    public void setColumnSizes(int ... sizes) {
        if (sizes == null || sizes.length == 0) {
            return;
        }
        StringBuilder s = new StringBuilder();
        for (int size : sizes) {
            if (s.length() > 0) {
                s.append(' ');
            }
            s.append((String)(size <= 0 ? "auto" : size + "fr"));
        }
        this.style("grid-template-columns", s.toString());
    }

    public void setColumns(int numberOfColumns) {
        this.setColumnSizes(GridLayout.sizes(numberOfColumns));
    }

    private static int[] sizes(int numberOfColumns) {
        if (numberOfColumns < 1) {
            numberOfColumns = 4;
        }
        int[] sizes = new int[numberOfColumns];
        for (int i = 0; i < numberOfColumns; ++i) {
            sizes[i] = 0;
        }
        return sizes;
    }
}

