/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.grid.Grid;
import java.util.function.Function;

public final class GridColumnDetail<T> {
    private Grid.Column<T> column;
    private String caption;
    private String label;
    private Function<T, ?> valueFunction;
    private Class<?> valueType;
    private MenuItem contextMenu;

    GridColumnDetail() {
    }

    void setColumn(Grid.Column<T> column) {
        this.column = column;
    }

    public Grid.Column<T> getColumn() {
        return this.column;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        if (this.column != null) {
            this.column.setHeader(caption);
        }
        this.caption = caption;
    }

    public Function<T, ?> getValueFunction() {
        return this.valueFunction;
    }

    @SafeVarargs
    final void setValueFunction(Function<T, ?> ... valueFunctions) {
        if (valueFunctions.length == 1) {
            this.valueFunction = valueFunctions[0];
            return;
        }
        this.valueFunction = o -> {
            Object[] values = new Object[valueFunctions.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = valueFunctions[i].apply(o);
            }
            return values;
        };
    }

    public Class<?> getValueType() {
        return this.valueType;
    }

    void setValueType(Class<?> valueType) {
        this.valueType = valueType;
    }

    void setContextMenu(MenuItem contextMenu) {
        this.contextMenu = contextMenu;
    }

    MenuItem getContextMenu() {
        return this.contextMenu;
    }

    public void setVisible(boolean visible) {
        if (this.column.isVisible() == visible) {
            if (this.contextMenu == null) {
                return;
            }
            if (this.contextMenu.isChecked() == visible) {
                return;
            }
            this.contextMenu.setChecked(visible);
            return;
        }
        this.column.setVisible(visible);
        this.setVisible(visible);
        this.column.getGrid().recalculateColumnWidths();
    }

    public String getLabel() {
        return this.label == null ? this.caption : this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        if (this.contextMenu != null) {
            this.contextMenu.setText(label);
        }
    }
}

