/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.ApplicationEnvironment;
import com.storedobject.vaadin.Clickable;
import com.storedobject.vaadin.CustomTextField;
import com.vaadin.flow.component.BlurNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.FocusNotifier;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;

public abstract class FreeFormatField<T>
extends CustomTextField<T> {
    private ItemLabelGenerator<T> displayGenerator;

    protected FreeFormatField(String label, T defaultValue) {
        this(label, defaultValue, null);
    }

    protected FreeFormatField(String label, T defaultValue, HasValue<?, String> displayComponent) {
        super(defaultValue);
        TextField display = displayComponent == null ? new TextField() : displayComponent;
        this.add(new Component[]{(Component)display});
        this.setItemLabelGenerator(null);
        ((HasValue)this.getField()).addValueChangeListener(arg_0 -> this.lambda$new$867dea89$1((HasValue)display, arg_0));
        ((Focusable)this.getField()).addBlurListener(arg_0 -> this.lambda$new$19d1cc80$1((HasValue)display, arg_0));
        ((Focusable)display).addFocusListener(arg_0 -> this.lambda$new$19d1cc80$2((HasValue)display, arg_0));
        new Clickable<Component>((Component)display, arg_0 -> this.lambda$new$19b891d6$1((HasValue)display, arg_0));
        ((HasSize)display).setWidthFull();
        ((Component)display).setVisible(true);
        display.setReadOnly(true);
        ((Component)this.getField()).setVisible(false);
        if (label != null) {
            this.setLabel(label);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        if (readOnly) {
            ((Component)this.getField()).setVisible(false);
        }
    }

    public void setValue(T value) {
        if (value == null) {
            value = this.getEmptyValue();
        }
        this.getField().setValue(this.displayGenerator.apply(value));
        super.setValue(value);
    }

    @Override
    protected final String format(T value) {
        String v = this.getField().getValue();
        return v == null || v.isBlank() ? this.displayGenerator.apply(value) : v;
    }

    public void setItemLabelGenerator(ItemLabelGenerator<T> displayGenerator) {
        if (displayGenerator == null) {
            ApplicationEnvironment ae = ApplicationEnvironment.get();
            displayGenerator = ae == null ? (ItemLabelGenerator & Serializable)t -> t == null ? "" : t.toString() : ae::toDisplay;
        }
        this.displayGenerator = displayGenerator;
    }

    private /* synthetic */ void lambda$new$19b891d6$1(HasValue display, Component e) {
        if (!this.isReadOnly()) {
            ((Component)display).setVisible(false);
            ((Component)this.getField()).setVisible(true);
            ((Focusable)this.getField()).focus();
        }
    }

    private /* synthetic */ void lambda$new$19d1cc80$2(HasValue display, FocusNotifier.FocusEvent e) {
        boolean ro = this.isReadOnly();
        ((Component)display).setVisible(ro);
        ((Component)this.getField()).setVisible(!ro);
        ((Focusable)this.getField()).focus();
    }

    private /* synthetic */ void lambda$new$19d1cc80$1(HasValue display, BlurNotifier.BlurEvent e) {
        ((Component)display).setVisible(true);
        ((Component)this.getField()).setVisible(false);
    }

    private /* synthetic */ void lambda$new$867dea89$1(HasValue display, HasValue.ValueChangeEvent e) {
        display.setValue((Object)this.displayGenerator.apply(this.getModelValue((String)e.getValue())));
        ((Component)display).setVisible(true);
        ((Component)this.getField()).setVisible(false);
    }
}

