/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.Application;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.formlayout.FormLayout;

public class FormLayout
extends com.vaadin.flow.component.formlayout.FormLayout {
    private int columns = 2;

    public FormLayout() {
        this.setColumns(this.columns);
    }

    public FormLayout(Component ... components) {
        super(components);
        this.setColumns(this.columns);
    }

    public void setColumns(int columns) {
        int w;
        Application a = Application.get();
        int n = w = a == null ? 1024 : a.getDeviceWidth();
        if (columns < 0) {
            columns = 2;
        } else if (columns > 6) {
            columns = 6;
        }
        if (w <= 0) {
            w = 1024;
        }
        w /= columns;
        FormLayout.ResponsiveStep[] steps = new FormLayout.ResponsiveStep[columns];
        for (int c = 0; c < columns; ++c) {
            steps[c] = new FormLayout.ResponsiveStep(c * w + "px", c + 1);
        }
        this.setResponsiveSteps(steps);
        this.columns = columns;
    }

    public final int getColumns() {
        return this.columns;
    }

    public void newLine() {
        this.add(new Component[]{new Html("<br>")});
    }

    public void setColumnSpan(Component component, int columnSpan) {
        this.setColspan(component, Math.min(Math.max(1, columnSpan), this.columns));
    }

    public int getColumnSpan(Component component) {
        return this.getColspan(component);
    }
}

