/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.Application;
import com.storedobject.vaadin.ApplicationMenuItem;
import com.storedobject.vaadin.ChangedValues;
import com.storedobject.vaadin.ClickHandler;
import com.storedobject.vaadin.CloseableView;
import com.storedobject.vaadin.FullScreen;
import com.storedobject.vaadin.HomeView;
import com.storedobject.vaadin.ValueChangeHandler;
import com.storedobject.vaadin.View;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.notification.Notification;

public interface ExecutableView
extends Runnable,
ClickHandler,
ValueChangeHandler {
    default public void warning(Object message) {
        Application.notification(this.getApplication(), this, message, 1, null);
    }

    default public void tray(Object message) {
        Application.notification(this.getApplication(), this, message, 1, Notification.Position.BOTTOM_END);
    }

    default public void message(Object message) {
        Application.notification(this.getApplication(), this, message, 0, null);
    }

    default public void error(Object message) {
        Application.notification(this.getApplication(), this, message, 2, null);
    }

    default public void clearAlerts() {
        Application.clearAlerts(this);
    }

    default public View getView() {
        return this.getView(false);
    }

    public View getView(boolean var1);

    @Override
    default public void run() {
        this.execute();
    }

    default public void execute() {
        this.execute(null);
    }

    default public void execute(View lock) {
        View v = this.getView(true);
        if (v != null) {
            v.execute(lock);
        }
    }

    default public void invoke(View parent) {
        View v = this.getView(true);
        if (v != null) {
            v.invoke(parent);
        }
    }

    default public void close() {
        View v = this.getView(false);
        if (v != null && v != this) {
            v.close();
        }
    }

    default public void abort() {
        View v = this.getView(false);
        if (v != null && v != this) {
            v.abort();
        }
    }

    default public void clean() {
        View v = this.getView(false);
        if (v != null && v != this) {
            v.clean();
        }
    }

    default public String getCaption() {
        View v = this.getView(false);
        if (v != null && v != this) {
            return v.getCaption();
        }
        return null;
    }

    default public void setCaption(String caption) {
        View v = this.getView(false);
        if (v != null && v != this) {
            v.setCaption(caption);
        }
    }

    default public void trackValueChange(HasValue<?, ?> field) {
        field.addValueChangeListener((HasValue.ValueChangeListener)this);
    }

    default public void setClickable(HasValue<?, ?> field) {
        this.trackValueChange(field);
    }

    default public <A extends Application> A getApplication() {
        return (A)Application.get();
    }

    default public void returnedFrom(View parent) {
    }

    @Override
    default public void valueChanged(ChangedValues changedValues) {
        HasValue<?, ?> field = changedValues.getChanged();
        if (field instanceof Component) {
            this.clicked((Component)field);
        }
    }

    @Override
    default public void clicked(Component c) {
    }

    default public void log(Object anything) {
        Object application = this.getApplication();
        if (application != null) {
            ((Application)application).log(anything);
        } else {
            System.err.println(anything);
        }
    }

    default public void log(Object anything, Throwable error) {
        Object application = this.getApplication();
        if (application != null) {
            ((Application)application).log(anything, error);
        } else {
            System.err.println(anything);
            error.printStackTrace();
        }
    }

    default public ApplicationMenuItem getMenuItem(Runnable menuAction) {
        ApplicationMenuItem m = this.createMenuItem(menuAction);
        if (m == null) {
            m = ((Application)this.getApplication()).getEnvironment().createMenuItem(this, this.getCaption(), menuAction);
        }
        return m;
    }

    default public ApplicationMenuItem createMenuItem(Runnable menuAction) {
        return ((Application)this.getApplication()).getEnvironment().createMenuItem(this, this.getCaption(), menuAction);
    }

    default public String getMenuIconName() {
        return ((Application)this.getApplication()).getEnvironment().getActiveMenuIconName();
    }

    default public boolean isCloseable() {
        if (this instanceof CloseableView) {
            return true;
        }
        ExecutableView executableView = this;
        if (executableView instanceof View) {
            View v = (View)executableView;
            return v.getComponent() instanceof CloseableView;
        }
        return false;
    }

    default public boolean isHomeView() {
        if (this instanceof HomeView) {
            return true;
        }
        ExecutableView executableView = this;
        if (executableView instanceof View) {
            View v = (View)executableView;
            return v.getComponent() instanceof HomeView;
        }
        return false;
    }

    default public boolean isFullScreen() {
        if (this instanceof FullScreen) {
            return true;
        }
        ExecutableView executableView = this;
        if (executableView instanceof View) {
            View v = (View)executableView;
            return v.getComponent() instanceof FullScreen;
        }
        return false;
    }

    default public void speak(String sentence) {
        Object a = this.getApplication();
        if (a != null) {
            ((Application)a).speak(sentence);
        }
    }
}

