/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.Box;
import com.storedobject.vaadin.ButtonLayout;
import com.storedobject.vaadin.ClickHandler;
import com.storedobject.vaadin.Clickable;
import com.storedobject.vaadin.HasSize;
import com.storedobject.vaadin.Icon;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Tag(value="div")
public class DetailComponent
extends Composite<Div>
implements HasSize {
    private final Div body = new Div();
    private Icon headerIcon;
    private final ContentSection contentLayout = new ContentSection();
    private final ClickHandler clickHandler = (ClickHandler & Serializable)c -> this.toggle(true);
    private List<ToggleListener> listeners;

    public DetailComponent() {
        this("", (Component[])null);
    }

    public DetailComponent(String header, Component ... content) {
        this(header, (Component)null, content);
    }

    public DetailComponent(Component header, Component ... content) {
        this((String)null, header, content);
    }

    private DetailComponent(String headerText, Component header, Component ... content) {
        this.contentLayout.setVisible(false);
        if (headerText != null) {
            header = this.constructHeader(headerText);
        }
        if (header == null) {
            header = this.constructHeader("");
        }
        new Clickable<Component>(header, this.clickHandler);
        if (content != null) {
            this.contentLayout.add(content);
        }
        this.body.add(new Component[]{header, this.contentLayout});
    }

    protected final Div initContent() {
        return this.body;
    }

    public void setHeader(Component header) {
        if (header == null) {
            return;
        }
        this.body.getElement().removeChild(0);
        new Clickable<Component>(header, this.clickHandler);
        this.body.getElement().insertChild(0, new Element[]{header.getElement()});
    }

    public void setHeader(String header) {
        this.setHeader(this.constructHeader(header));
    }

    public Div getContentLayout() {
        return this.contentLayout;
    }

    public void addContent(Component ... components) {
        this.contentLayout.add(components);
    }

    public void setContent(Component ... components) {
        this.contentLayout.setContent(components);
    }

    public void clearContent() {
        this.contentLayout.removeAll();
    }

    private Component constructHeader(String header) {
        if (header == null) {
            header = "";
        }
        ButtonLayout summaryLayout = new ButtonLayout();
        HasComponents titleComponent = this.createHeader(header);
        if (!(titleComponent instanceof Component)) {
            titleComponent = new Span(header);
            ((HasStyle)titleComponent).getStyle().set("font-size", "var(--lumo-font-size-xl)").set("font-weight", "bold");
        }
        Style style = titleComponent.getElement().getStyle();
        style.set("padding", "0px");
        style.set("margin", "0px");
        style.set("display", "flex");
        style.set("flex-grow", "100");
        summaryLayout.setWidthFull();
        this.headerIcon = new Icon(this.contentLayout.isVisible() ? VaadinIcon.CHEVRON_CIRCLE_RIGHT : VaadinIcon.CHEVRON_CIRCLE_DOWN);
        summaryLayout.add(new Component[]{(Component)titleComponent, this.headerIcon});
        Box box = new Box((Component)summaryLayout);
        box.alignSizing();
        box.setStyle("cursor", "pointer");
        return summaryLayout;
    }

    protected HasComponents createHeader(String headerText) {
        return null;
    }

    public void collapse() {
        if (this.contentLayout.isVisible()) {
            this.toggle(false);
        }
    }

    public void expand() {
        if (!this.contentLayout.isVisible()) {
            this.toggle(false);
        }
    }

    public void toggle() {
        this.toggle(false);
    }

    private void toggle(boolean fromClient) {
        this.contentLayout.setVisible(!this.contentLayout.isVisible());
        if (this.listeners != null) {
            ToggledEvent event = new ToggledEvent(this, fromClient, this.contentLayout.isVisible());
            this.listeners.forEach(listener -> listener.toggled(event));
        }
    }

    public Registration addToggleListener(ToggleListener toggleListener) {
        if (toggleListener == null) {
            return null;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<ToggleListener>();
        }
        this.listeners.add(toggleListener);
        return (Registration & Serializable)() -> this.listeners.remove(toggleListener);
    }

    private class ContentSection
    extends Div {
        private int componentCount = 0;

        private ContentSection() {
        }

        public void setVisible(boolean visible) {
            if (visible && this.componentCount == 0) {
                visible = false;
            }
            super.setVisible(visible);
            this.updateIcon();
        }

        public void add(Component ... components) {
            super.add(components);
            this.updateComponentCount();
        }

        public void add(String text) {
            super.add(text);
            this.updateComponentCount();
        }

        public void addComponentAsFirst(Component component) {
            super.addComponentAsFirst(component);
            this.updateComponentCount();
        }

        public void addComponentAtIndex(int index, Component component) {
            super.addComponentAtIndex(index, component);
            this.updateComponentCount();
        }

        public void remove(Component ... components) {
            super.remove(components);
            this.updateComponentCount();
        }

        public void removeAll() {
            super.removeAll();
            this.updateComponentCount();
        }

        private void setContent(Component ... components) {
            super.removeAll();
            this.add(components);
        }

        private void updateComponentCount() {
            this.componentCount = (int)this.getChildren().count();
            this.setVisible(this.isVisible());
        }

        private void updateIcon() {
            if (DetailComponent.this.headerIcon != null) {
                DetailComponent.this.headerIcon.setIcon(this.isVisible() ? VaadinIcon.CHEVRON_CIRCLE_RIGHT : (this.componentCount == 0 ? VaadinIcon.MINUS_CIRCLE : VaadinIcon.CHEVRON_CIRCLE_DOWN));
            }
        }
    }

    public static class ToggledEvent
    extends ComponentEvent<DetailComponent> {
        private final boolean expanded;

        public ToggledEvent(DetailComponent source, boolean fromClient, boolean expanded) {
            super((Component)source, fromClient);
            this.expanded = expanded;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public boolean isCollapsed() {
            return !this.expanded;
        }
    }

    @FunctionalInterface
    public static interface ToggleListener {
        public void toggled(ToggledEvent var1);
    }
}

