/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.LegacyDateField;
import com.storedobject.vaadin.TranslatedField;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.datepicker.DatePicker;
import java.time.LocalDate;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateField
extends TranslatedField<java.sql.Date, LocalDate> {
    private static java.sql.Date today = null;
    static java.sql.Date nullValue = new java.sql.Date(-5364662400000L);
    private final Converter converter;

    public DateField() {
        this((String)null);
    }

    public DateField(String label) {
        this(label, DateField.today());
    }

    public DateField(java.sql.Date initialValue) {
        this(null, initialValue);
    }

    public DateField(String label, java.sql.Date initialValue) {
        this(label, new Converter(), initialValue);
    }

    private DateField(String label, Converter converter, java.sql.Date initialValue) {
        super(new DatePicker(), converter::create, (f, d) -> converter.create(d), null);
        this.converter = converter;
        this.setLabel(label);
        this.setValue(initialValue);
        this.getField().setClearButtonVisible(false);
    }

    public void setValue(java.sql.Date value) {
        super.setValue(value == null || value.equals(nullValue) ? null : value);
    }

    public java.sql.Date getValue() {
        java.sql.Date d = (java.sql.Date)super.getValue();
        return d == null ? nullValue : d;
    }

    static java.sql.Date today() {
        if (today == null) {
            today = Converter.create(LocalDate.now(), 0);
        }
        return today;
    }

    public static void setToday(java.sql.Date today) {
        if (today != null) {
            boolean setNullToo = DateField.today == nullValue;
            DateField.today = today;
            if (setNullToo) {
                nullValue = today;
            }
        }
    }

    public DatePicker getField() {
        return (DatePicker)super.getField();
    }

    public void setMin(java.sql.Date value) {
        this.getField().setMin(value == null ? null : this.converter.create(value));
    }

    public void setMax(java.sql.Date value) {
        this.getField().setMax(value == null ? null : this.converter.create(value));
    }

    public java.sql.Date getMin() {
        LocalDate d = this.getField().getMin();
        return d == null ? null : this.converter.create(null, d);
    }

    public java.sql.Date getMax() {
        LocalDate d = this.getField().getMax();
        return d == null ? null : this.converter.create(null, d);
    }

    public boolean isRequired() {
        return this.getField().isRequired();
    }

    public void setRequired(boolean required) {
        this.getField().setRequired(required);
    }

    public void setWeekNumbersVisible(boolean weekNumbersVisible) {
        this.getField().setWeekNumbersVisible(weekNumbersVisible);
    }

    public boolean isWeekNumbersVisible() {
        return this.getField().isWeekNumbersVisible();
    }

    public static void setNullValue(java.sql.Date nullValue) {
        DateField.nullValue = nullValue;
        LegacyDateField.setNullValue();
    }

    protected boolean valueEquals(java.sql.Date value1, java.sql.Date value2) {
        if (nullValue != null) {
            if (value1 != null && value1.getTime() == nullValue.getTime()) {
                value1 = null;
            }
            if (value2 != null && value2.getTime() == nullValue.getTime()) {
                value2 = null;
            }
        }
        return super.valueEquals((Object)value1, (Object)value2);
    }

    public void setEpoch(int epoch) {
        this.converter.setEpoch(epoch);
    }

    public int getEpoch() {
        return this.converter.getEpoch();
    }

    private static class Converter {
        private int epoch = Converter.getYear(DateField.today()) / 100 * 100;

        Converter() {
        }

        java.sql.Date create(HasValue<?, LocalDate> f, LocalDate date) {
            java.sql.Date d = Converter.create(date, this.epoch);
            if (f != null && Converter.getYear(d) != date.getYear()) {
                f.setValue((Object)LocalDate.of(Converter.getYear(d), date.getMonthValue(), date.getDayOfMonth()));
            }
            return d;
        }

        static java.sql.Date create(LocalDate date, int epoch) {
            if (date == null) {
                return null;
            }
            int year = date.getYear();
            if (year < 100) {
                year += epoch;
            }
            GregorianCalendar c = new GregorianCalendar(year, date.getMonthValue() - 1, date.getDayOfMonth());
            c.setTimeZone(TimeZone.getTimeZone("GMT"));
            return new java.sql.Date(c.getTimeInMillis());
        }

        <D extends Date> LocalDate create(D date) {
            return date == null ? null : LocalDate.of(Converter.getYear(date), Converter.getMonth(date), Converter.getDay(date));
        }

        private static <D extends Date> int getYear(D date) {
            return Converter.get(date, 1);
        }

        private static <D extends Date> int getMonth(D date) {
            return Converter.get(date, 2) + 1;
        }

        private static <D extends Date> int getDay(D date) {
            return Converter.get(date, 5);
        }

        private static <D extends Date> int get(D date, int field) {
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(date);
            return c.get(field);
        }

        void setEpoch(int epoch) {
            this.epoch = epoch;
        }

        int getEpoch() {
            return this.epoch;
        }
    }
}

