/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.ApplicationEnvironment;
import com.storedobject.vaadin.ConstructedListener;
import com.storedobject.vaadin.GridRow;
import com.storedobject.vaadin.HasColumns;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.treegrid.TreeGrid;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

@CssImport(value="./so/grid/styles.css")
public class DataTreeGrid<T>
extends TreeGrid<T>
implements HasColumns<T> {
    private final HasColumns.SOGrid<T> soGrid;
    private boolean firstFooter = true;
    private List<ConstructedListener> constructedListeners;

    public DataTreeGrid(Class<T> objectClass) {
        this(objectClass, null);
    }

    public DataTreeGrid(Class<T> objectClass, Iterable<String> columns) {
        this.soGrid = new HasColumns.SOGrid<T>(this, objectClass, columns);
    }

    @Override
    public boolean isColumnSortable(String columnName) {
        return false;
    }

    @Override
    public final HasColumns.SOGrid<T> getSOGrid() {
        return this.soGrid;
    }

    @Override
    public Registration addConstructedListener(ConstructedListener constructedListener) {
        if (this.soGrid.rendered()) {
            constructedListener.constructed(this);
            return (Registration & Serializable)() -> {};
        }
        if (this.constructedListeners == null) {
            this.constructedListeners = new ArrayList<ConstructedListener>();
        }
        this.constructedListeners.add(constructedListener);
        return (Registration & Serializable)() -> this.constructedListeners.remove(constructedListener);
    }

    @Override
    public Stream<ConstructedListener> streamConstructedListeners() {
        return this.constructedListeners == null ? Stream.empty() : this.constructedListeners.stream();
    }

    @Override
    public void clearConstructedListeners() {
        this.constructedListeners = null;
    }

    public boolean isColumnReorderingAllowed() {
        return this.soGrid.rendered() ? super.isColumnReorderingAllowed() : this.soGrid.isColumnReorderingAllowed();
    }

    public void setColumnReorderingAllowed(boolean allowColumnReordering) {
        if (this.soGrid.rendered()) {
            super.setColumnReorderingAllowed(allowColumnReordering);
        } else {
            this.soGrid.setColumnReorderingAllowed(allowColumnReordering);
        }
    }

    public final List<Grid.Column<T>> getColumns() {
        if (this.soGrid.rendered()) {
            return super.getColumns();
        }
        return this.soGrid.getColumns();
    }

    public final Grid.Column<T> getColumnByKey(String columnKey) {
        if (this.soGrid.rendered()) {
            return super.getColumnByKey(columnKey);
        }
        return this.soGrid.getColumnByKey(columnKey);
    }

    public Grid.Column<T> addHierarchyColumn(ValueProvider<T, ?> valueProvider) {
        return null;
    }

    @Override
    public Grid.Column<T> createHierarchyColumn(String columnName, ValueProvider<T, ?> valueProvider) {
        if (this.soGrid.treeCreated() || columnName == null) {
            return null;
        }
        this.soGrid.treeBuilt(columnName);
        Grid.Column column = super.addHierarchyColumn(valueProvider);
        this.soGrid.acceptColumn(column, columnName);
        return column;
    }

    @Override
    public Grid.Column<T> createHTMLHierarchyColumn(String columnName, Function<T, ?> htmlFunction) {
        if (this.soGrid.treeCreated() || columnName == null) {
            return null;
        }
        this.soGrid.treeBuilt(columnName);
        Grid.Column column = super.addColumn((Renderer)LitRenderer.of((String)"<vaadin-grid-tree-toggle\n    @click=${onClick}\n    .leaf=${!item.children}\n    .expanded=${model.expanded}\n    .level=${model.level}>\n    <div .innerHTML=${item.html} style=\"display: inline-block\"></div>\n</vaadin-grid-tree-toggle>\n").withProperty("children", (ValueProvider & Serializable)item -> this.getDataCommunicator().hasChildren(item)).withProperty("html", (ValueProvider & Serializable)item -> Objects.requireNonNull(ApplicationEnvironment.get()).toDisplay(htmlFunction.apply(item))).withFunction("onClick", (SerializableConsumer & Serializable)item -> {
            if (this.getDataCommunicator().hasChildren(item)) {
                if (this.isExpanded(item)) {
                    this.collapse(List.of(item));
                } else {
                    this.expand(List.of(item));
                }
            }
        }));
        this.soGrid.acceptColumn(column, columnName);
        return column;
    }

    @Override
    public GridRow appendFooter() {
        if (this.firstFooter) {
            HasColumns.super.appendFooter();
            this.firstFooter = false;
        }
        return HasColumns.super.appendFooter();
    }
}

