/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;

public class DataList<T>
implements List<T> {
    private final List<T> data;
    private List<RefreshListener<T>> listeners;

    public DataList() {
        this(null);
    }

    public DataList(List<T> data) {
        this.data = data == null ? new ArrayList() : data;
    }

    public List<T> getData() {
        return this.data;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean contains(Object item) {
        return this.data.contains(item);
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.data.iterator();
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    @Nonnull
    public <T1> T1[] toArray(@Nonnull T1[] a) {
        return this.data.toArray(a);
    }

    @Override
    public boolean add(T item) {
        this.data.add(item);
        this.refresh();
        return true;
    }

    @Override
    public boolean remove(Object item) {
        if (this.data.remove(item)) {
            this.refresh();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> collection) {
        return this.data.containsAll(collection);
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends T> collection) {
        if (this.data.addAll(collection)) {
            this.refresh();
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, @Nonnull Collection<? extends T> collection) {
        if (this.data.addAll(index, collection)) {
            this.refresh();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> collection) {
        if (this.data.removeAll(collection)) {
            this.refresh();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        if (this.data.removeIf(filter)) {
            this.refresh();
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> collection) {
        if (this.data.retainAll(collection)) {
            this.refresh();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.data.clear();
        this.refresh();
    }

    @Override
    public T get(int index) {
        return this.data.get(index);
    }

    @Override
    public T set(int index, T item) {
        T d = this.data.set(index, item);
        this.refresh(item);
        return d;
    }

    @Override
    public void add(int index, T item) {
        this.data.add(index, item);
        this.refresh();
    }

    @Override
    public T remove(int index) {
        T item = this.data.remove(index);
        if (item != null) {
            this.refresh();
        }
        return item;
    }

    @Override
    public int indexOf(Object item) {
        return this.data.indexOf(item);
    }

    @Override
    public int lastIndexOf(Object item) {
        return this.data.lastIndexOf(item);
    }

    @Override
    @Nonnull
    public ListIterator<T> listIterator() {
        return this.data.listIterator();
    }

    @Override
    @Nonnull
    public ListIterator<T> listIterator(int index) {
        return this.data.listIterator(index);
    }

    @Override
    @Nonnull
    public List<T> subList(int fromIndex, int toIndex) {
        return this.data.subList(fromIndex, toIndex);
    }

    public void refresh() {
        if (this.listeners != null) {
            this.listeners.forEach(RefreshListener::refresh);
        }
    }

    public void refresh(T item) {
        if (this.listeners != null) {
            this.listeners.forEach(listener -> listener.refresh(item));
        }
    }

    public Registration addRefreshListener(RefreshListener<T> listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<RefreshListener<T>>();
        }
        this.listeners.add(listener);
        return (Registration & Serializable)() -> this.listeners.remove(listener);
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        this.data.sort(comparator);
        this.refresh();
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        this.data.replaceAll(operator);
        this.refresh();
    }

    public static interface RefreshListener<T> {
        public void refresh();

        public void refresh(T var1);
    }
}

