/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.ConstructedListener;
import com.storedobject.vaadin.GridRow;
import com.storedobject.vaadin.HasColumns;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

@CssImport(value="./so/grid/styles.css", themeFor="vaadin-grid")
public class DataGrid<T>
extends Grid<T>
implements HasColumns<T> {
    private final HasColumns.SOGrid<T> soGrid;
    private boolean firstFooter = true;
    private List<ConstructedListener> constructedListeners;

    public DataGrid(Class<T> objectClass) {
        this(objectClass, null);
    }

    public DataGrid(Class<T> objectClass, Iterable<String> columns) {
        this.soGrid = new HasColumns.SOGrid<T>(this, objectClass, columns);
        this.setMultiSort(true);
    }

    @Override
    public final HasColumns.SOGrid<T> getSOGrid() {
        return this.soGrid;
    }

    @Override
    public Registration addConstructedListener(ConstructedListener constructedListener) {
        if (this.soGrid.rendered()) {
            constructedListener.constructed(this);
            return (Registration & Serializable)() -> {};
        }
        if (this.constructedListeners == null) {
            this.constructedListeners = new ArrayList<ConstructedListener>();
        }
        this.constructedListeners.add(constructedListener);
        return (Registration & Serializable)() -> this.constructedListeners.remove(constructedListener);
    }

    @Override
    public Stream<ConstructedListener> streamConstructedListeners() {
        return this.constructedListeners == null ? Stream.empty() : this.constructedListeners.stream();
    }

    @Override
    public void clearConstructedListeners() {
        this.constructedListeners = null;
    }

    public boolean isColumnReorderingAllowed() {
        return this.soGrid.rendered() ? super.isColumnReorderingAllowed() : this.soGrid.isColumnReorderingAllowed();
    }

    public void setColumnReorderingAllowed(boolean allowColumnReordering) {
        if (this.soGrid.rendered()) {
            super.setColumnReorderingAllowed(allowColumnReordering);
        } else {
            this.soGrid.setColumnReorderingAllowed(allowColumnReordering);
        }
    }

    public final List<Grid.Column<T>> getColumns() {
        if (this.soGrid.rendered()) {
            return super.getColumns();
        }
        return this.soGrid.getColumns();
    }

    public final Grid.Column<T> getColumnByKey(String columnKey) {
        if (this.soGrid.rendered()) {
            return super.getColumnByKey(columnKey);
        }
        return this.soGrid.getColumnByKey(columnKey);
    }

    @Override
    public GridRow appendFooter() {
        if (this.firstFooter) {
            HasColumns.super.appendFooter();
            this.firstFooter = false;
        }
        return HasColumns.super.appendFooter();
    }
}

