/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.AbstractDataForm;
import com.storedobject.vaadin.Application;
import com.storedobject.vaadin.Button;
import com.storedobject.vaadin.ButtonLayout;
import com.storedobject.vaadin.CenteredLayout;
import com.storedobject.vaadin.ClickHandler;
import com.storedobject.vaadin.Form;
import com.storedobject.vaadin.Window;
import com.storedobject.vaadin.WindowDecorator;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;

public abstract class DataForm
extends AbstractDataForm<Object> {
    protected Button ok;
    protected Button cancel;
    protected HasComponents buttonPanel;
    private boolean buttonsAtTop = false;
    private final boolean windowMode;
    private final boolean centered;
    private WindowDecorator windowDecorator;
    private boolean closeable = true;

    public DataForm(String caption) {
        this(caption, null, null);
    }

    public DataForm(String caption, boolean windowMode) {
        this(caption, null, null, windowMode);
    }

    public DataForm(String caption, boolean windowMode, boolean centered) {
        this(caption, null, null, windowMode, centered);
    }

    public DataForm(String caption, String labelOK, String labelCancel) {
        this(caption, labelOK, labelCancel, true);
    }

    public DataForm(String caption, String labelOK, String labelCancel, boolean windowMode) {
        this(caption, labelOK, labelCancel, windowMode, false);
    }

    public DataForm(String caption, String labelOK, String labelCancel, boolean windowMode, boolean centered) {
        this.form = new Form();
        this.form.setView(this);
        this.setErrorDisplay(null);
        this.setCaption(caption);
        this.ok = new Button(labelOK == null || labelOK.isEmpty() ? "Ok" : labelOK, (ClickHandler)this).asPrimary();
        this.ok.setDisableOnClick(true);
        this.cancel = new Button(labelCancel == null || labelCancel.isEmpty() ? "Cancel" : labelCancel, (ClickHandler)this);
        this.windowMode = windowMode;
        this.centered = centered;
        if (windowMode || centered) {
            this.setColumns(1);
        }
    }

    @Override
    protected final void initUI() {
        HasComponents v;
        this.buttonPanel = this.createButtonLayout();
        if (this.buttonPanel == null) {
            this.buttonPanel = this.createDefaultButtonLayout();
        }
        if ((v = this.createLayout()) == null) {
            v = this.createDefaultLayout();
        }
        if (this.buttonsAtTop) {
            v.add(new Component[]{(Component)this.buttonPanel, this.getForm().getComponent()});
        } else {
            v.add(new Component[]{this.getForm().getComponent(), (Component)this.buttonPanel});
        }
        this.buildFields();
        this.buildButtons();
        Object c = (Component)v;
        if (this.windowMode) {
            Window window = this.createWindow((Component)c);
            if (window == null) {
                Component[] componentArray = new Component[2];
                this.windowDecorator = new WindowDecorator(this, new Component[0]);
                componentArray[0] = this.windowDecorator;
                componentArray[1] = c;
                window = new Window(componentArray);
                this.windowDecorator.setCloseable(this.closeable);
            }
            this.setComponent((Component)window);
            this.sizeIt();
        } else {
            if (this.centered) {
                c = new CenteredLayout((Component)c);
            }
            this.setComponent((Component)c);
            if (this.centered) {
                this.sizeIt();
            }
        }
    }

    private void sizeIt() {
        this.getContent().getElement().getStyle().set("min-width", DataForm.minMax(this.getMinimumContentWidth()) + "vw").set("min-height", DataForm.minMax(this.getMinimumContentHeight()) + "vh").set("max-width", DataForm.maxMin(this.getMaximumContentWidth()) + "vw").set("max-height", DataForm.maxMin(this.getMaximumContentHeight()) + "vh");
        this.sizeSet();
    }

    protected void sizeSet() {
    }

    public int getMinimumContentWidth() {
        return 10;
    }

    public int getMaximumContentWidth() {
        return 80;
    }

    public int getMinimumContentHeight() {
        return 10;
    }

    public int getMaximumContentHeight() {
        return 80;
    }

    private static int minMax(int v) {
        return Math.max(10, Math.min(80, v));
    }

    private static int maxMin(int v) {
        Application a;
        if (v < 80 && (a = Application.get()) != null && a.getWebBrowser().isIPhone()) {
            v = 80;
        }
        return Math.min(90, Math.max(10, v));
    }

    @Override
    public void setWindowMode(boolean windowOn) {
        throw new UnsupportedOperationException("Window mode can't be changed");
    }

    @Override
    public boolean skipFirstFocus(Focusable<?> skipFocus) {
        return skipFocus == this.ok || skipFocus == this.cancel;
    }

    private HasComponents createDefaultLayout() {
        return this.centered ? new Div() : new VerticalLayout();
    }

    private HasComponents createDefaultButtonLayout() {
        return new ButtonLayout();
    }

    protected void buildFields() {
    }

    protected void buildButtons() {
        this.buttonPanel.add(new Component[]{this.ok, this.cancel});
    }

    protected void cancel() {
        this.abort();
    }

    protected abstract boolean process();

    @Override
    public void clicked(Component c) {
        if (c == this.cancel) {
            this.cancel();
            return;
        }
        if (c == this.ok) {
            if (this.commit()) {
                try {
                    try {
                        this.validateData();
                        if (this.process()) {
                            this.close();
                        }
                    }
                    catch (RuntimeException error) {
                        this.error(error);
                        this.abort();
                        return;
                    }
                }
                catch (Exception warn) {
                    this.warning(warn);
                }
            }
            this.ok.setEnabled(true);
            this.ok.setDisableOnClick(true);
        }
    }

    public void setButtonsAtTop(boolean buttonsAtTop) {
        this.buttonsAtTop = buttonsAtTop;
    }

    protected void validateData() throws Exception {
    }

    public void setCloseable(boolean closeable) {
        if (this.closeable == closeable) {
            return;
        }
        this.closeable = closeable;
        if (this.windowDecorator != null) {
            this.windowDecorator.setCloseable(closeable);
        }
    }
}

