/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.AbstractDataEditor;
import com.storedobject.vaadin.Button;
import com.storedobject.vaadin.ButtonLayout;
import com.storedobject.vaadin.ClickHandler;
import com.storedobject.vaadin.View;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import java.util.function.Consumer;

public class DataEditor<T>
extends AbstractDataEditor<T> {
    protected Button save;
    protected Button cancel;
    protected HasComponents buttonPanel;
    private Consumer<T> saveAction;
    private Consumer<T> cancelAction;

    public DataEditor(Class<T> objectClass) {
        this(objectClass, null, null, (Consumer)null, null);
    }

    public DataEditor(Class<T> objectClass, String caption) {
        this(objectClass, caption, null, null, null, null);
    }

    public DataEditor(Class<T> objectClass, String labelSave, String labelCancel) {
        this(objectClass, labelSave, labelCancel, (Consumer)null, null);
    }

    public DataEditor(Class<T> objectClass, String caption, String labelSave, String labelCancel) {
        this(objectClass, caption, labelSave, labelCancel, null, null);
    }

    public DataEditor(Class<T> objectClass, Consumer<T> saveAction) {
        this(objectClass, null, null, saveAction, null);
    }

    public DataEditor(Class<T> objectClass, String caption, Consumer<T> saveAction) {
        this(objectClass, caption, null, null, saveAction, null);
    }

    public DataEditor(Class<T> objectClass, String labelSave, String labelCancel, Consumer<T> saveAction) {
        this(objectClass, labelSave, labelCancel, saveAction, null);
    }

    public DataEditor(Class<T> objectClass, String caption, String labelSave, String labelCancel, Consumer<T> saveAction) {
        this(objectClass, caption, labelSave, labelCancel, saveAction, null);
    }

    public DataEditor(Class<T> objectClass, Consumer<T> saveAction, Consumer<T> cancelAction) {
        super(objectClass);
        this.init(null, null, saveAction, cancelAction);
    }

    public DataEditor(Class<T> objectClass, String caption, Consumer<T> saveAction, Consumer<T> cancelAction) {
        super(objectClass, caption);
        this.init(null, null, saveAction, cancelAction);
    }

    public DataEditor(Class<T> objectClass, String labelSave, String labelCancel, Consumer<T> saveAction, Consumer<T> cancelAction) {
        super(objectClass);
        this.init(labelSave, labelCancel, saveAction, cancelAction);
    }

    public DataEditor(Class<T> objectClass, String caption, String labelSave, String labelCancel, Consumer<T> saveAction, Consumer<T> cancelAction) {
        super(objectClass, caption);
        this.init(labelSave, labelCancel, saveAction, cancelAction);
    }

    private void init(String labelSave, String labelCancel, Consumer<T> saveAction, Consumer<T> cancelAction) {
        this.save = new Button(labelSave == null ? "Save" : labelSave, "ok", (ClickHandler)this).asPrimary();
        this.cancel = new Button(labelCancel == null ? "Cancel" : labelCancel, "cancel", (ClickHandler)this);
        this.saveAction = saveAction;
        this.cancelAction = cancelAction;
    }

    @Override
    protected void initUI() {
        HasComponents v;
        this.buttonPanel = this.createButtonLayout();
        if (this.buttonPanel == null) {
            this.buttonPanel = this.createDefaultButtonLayout();
        }
        if ((v = this.createLayout()) == null) {
            v = this.createDefaultLayout();
        }
        v.add(new Component[]{(Component)this.buttonPanel, this.getForm().getComponent()});
        this.buildButtons();
        this.setComponent((Component)v);
    }

    @Override
    public boolean skipFirstFocus(Focusable<?> skipFocus) {
        return skipFocus == this.save || skipFocus == this.cancel;
    }

    private HasComponents createDefaultLayout() {
        return new VerticalLayout();
    }

    private HasComponents createDefaultButtonLayout() {
        return new ButtonLayout();
    }

    protected void buildButtons() {
        this.buttonPanel.add(new Component[]{this.save, this.cancel});
    }

    @Override
    protected void execute(View parent, boolean doNotLock) {
        this.getComponent();
        if (this.getObject() == null) {
            this.setObject(this.newObject());
        }
        super.execute(parent, doNotLock);
    }

    protected void cancel() {
        this.abort();
        if (this.cancelAction != null) {
            this.cancelAction.accept(this.getObject());
        }
    }

    protected void save() {
        this.close();
        if (this.saveAction != null) {
            this.saveAction.accept(this.getObject());
        }
    }

    public void setSaveAction(Consumer<T> saveAction) {
        this.saveAction = saveAction;
    }

    public void setCancelAction(Consumer<T> cancelAction) {
        this.cancelAction = cancelAction;
    }

    protected void validateData() throws Exception {
    }

    @Override
    public void clicked(Component c) {
        if (c == this.cancel) {
            this.cancel();
            return;
        }
        if (c == this.save && this.commit()) {
            try {
                this.validateData();
            }
            catch (Exception e) {
                this.warning(e);
                return;
            }
            this.save();
        }
    }
}

