/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.Box;
import com.storedobject.vaadin.CSSGrid;
import com.storedobject.vaadin.ExecutableView;
import com.storedobject.vaadin.HasSize;
import com.storedobject.vaadin.View;
import com.storedobject.vaadin.ViewClosedListener;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.shared.Registration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Dashboard
extends CSSGrid
implements ExecutableView {
    private View view;
    private String caption;
    private final boolean boxing;
    private final Map<View, Registration> registrationMap = new HashMap<View, Registration>();
    private final ViewMonitor viewMonitor = new ViewMonitor();

    public Dashboard() {
        this(null, true);
    }

    public Dashboard(boolean boxing) {
        this(null, boxing);
    }

    public Dashboard(String caption) {
        this(caption, true);
    }

    public Dashboard(String caption, boolean boxing) {
        this.boxing = boxing;
        this.setCaption(caption);
        this.setMinimumColumnWidth(null);
        this.setAutoarrange(true);
        this.style("align-items", "start");
        this.style("place-content", "stretch");
    }

    public void setMinimumColumnWidth(String width) {
        if (width == null || width.isEmpty()) {
            width = "250px";
        }
        this.style("grid-template-columns", "repeat(auto-fill, minmax(" + width + ", 1fr))");
    }

    public void setAutoarrange(boolean autoarrange) {
        this.style("grid-auto-flow", autoarrange ? "row dense" : "row");
    }

    public boolean isAutoarrange() {
        return "row dense".equals(this.getStyle().get("grid-auto-flow"));
    }

    public void justify(View view, CSSGrid.Position position) {
        this.justify(view.getComponent(), position);
    }

    public void align(View view, CSSGrid.Position position) {
        this.align(view.getComponent(), position);
    }

    public void center(View view) {
        Component component = view.getComponent();
        this.justify(component, CSSGrid.Position.CENTER);
        this.align(component, CSSGrid.Position.CENTER);
    }

    @Override
    public void setColumnSpan(Component component, int numberOfColumns) {
        if (numberOfColumns > 6) {
            numberOfColumns = 6;
        }
        super.setColumnSpan(component, numberOfColumns);
    }

    public void setColumnSpan(View view, int numberOfColumns) {
        this.setColumnSpan(view.getComponent(), numberOfColumns);
    }

    public void setRowSpan(View view, int numberOfRows) {
        this.setRowSpan(view.getComponent(), numberOfRows);
    }

    public void add(Component ... components) {
        if (components == null) {
            return;
        }
        for (Component c : components) {
            if (c instanceof ExecutableView) {
                ((ExecutableView)c).getView(true);
            }
            if (this.boxing) {
                new Box(c).alignSizing();
            }
            if (!(c instanceof HasSize)) continue;
            ((HasSize)c).setWidth("100%");
            ((HasSize)c).setHeight("100%");
        }
        super.add(components);
    }

    public void add(View ... views) {
        if (views != null) {
            View thisView = this.getView(true);
            for (View v : views) {
                if (v == null) continue;
                v.setEmbeddedView(thisView);
                if (this.registrationMap.get(v) != null) continue;
                this.registrationMap.put(v, v.addClosedListener(this.viewMonitor));
                this.add(v.getComponent());
            }
        }
    }

    public void remove(View ... views) {
        if (views != null) {
            for (View v : views) {
                if (v == null) continue;
                v.abort();
            }
        }
    }

    @Override
    public void clicked(Component c) {
    }

    @Override
    public final View getView(boolean create) {
        if (this.view != null) {
            return this.view;
        }
        if (create) {
            this.view = this.createView();
        }
        if (this.view == null && create) {
            this.view = new View(this, this.getCaption()){

                @Override
                public boolean isCloseable() {
                    return Dashboard.this.isCloseable();
                }
            };
        }
        if (this.view != null) {
            this.view.addClosedListener(v -> this.closeInt());
        }
        return this.view;
    }

    protected View createView() {
        return null;
    }

    @Override
    public String getCaption() {
        return this.caption == null || this.caption.trim().isEmpty() ? "Dashboard" : this.caption;
    }

    @Override
    public void close() {
        if (this.view != null) {
            this.view.close();
        } else {
            this.closeInt();
        }
    }

    @Override
    public void abort() {
        if (this.view != null) {
            this.view.abort();
        } else {
            this.closeInt();
        }
    }

    private void closeInt() {
        new ArrayList<View>(this.registrationMap.keySet()).forEach(View::abort);
        this.clean();
    }

    @Override
    public void clean() {
    }

    @Override
    public void setCaption(String caption) {
        this.caption = caption;
    }

    private class ViewMonitor
    implements ViewClosedListener {
        private ViewMonitor() {
        }

        @Override
        public void viewClosed(View view) {
            Dashboard.this.remove(new Component[]{view.getComponent()});
            Registration r = Dashboard.this.registrationMap.get(view);
            if (r != null) {
                r.remove();
                Dashboard.this.registrationMap.remove(view);
            }
        }
    }
}

