/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.CustomField;
import com.storedobject.vaadin.DisablePaste;
import com.storedobject.vaadin.HasSize;
import com.storedobject.vaadin.HasStyle;
import com.storedobject.vaadin.TextField;
import com.storedobject.vaadin.util.HasTextValue;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.shared.HasPrefix;
import com.vaadin.flow.component.shared.HasSuffix;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.Autocomplete;
import com.vaadin.flow.component.textfield.HasAutocomplete;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.dom.Element;
import java.io.Serializable;
import java.util.Objects;

public abstract class CustomTextField<T>
extends CustomField<T>
implements HasPrefix,
HasSuffix,
HasStyle,
DisablePaste,
HasAutocomplete {
    private HasTextValue field;
    private String emptyDisplay;

    protected CustomTextField(T defaultValue) {
        super(defaultValue);
    }

    public void setWidth(String width) {
        super.setWidth(width);
        this.getField().setWidth(width);
    }

    public void setHeight(String height) {
        super.setHeight(height);
        this.getField().setHeight(height);
    }

    public void setMaxWidth(String maxWidth) {
        super.setMaxWidth(maxWidth);
        this.getField().setMaxWidth(maxWidth);
    }

    public void setMaxHeight(String maxHeight) {
        super.setMaxHeight(maxHeight);
        this.getField().setMaxHeight(maxHeight);
    }

    public void setMinWidth(String minWidth) {
        super.setMinWidth(minWidth);
        this.getField().setMinWidth(minWidth);
    }

    public void setMinHeight(String minHeight) {
        super.setMinHeight(minHeight);
        this.getField().setMinHeight(minHeight);
    }

    public void alignRight() {
        ((TextField)this.getField()).addThemeVariants((ThemeVariant[])new TextFieldVariant[]{TextFieldVariant.LUMO_ALIGN_RIGHT});
    }

    protected HasTextValue createField() {
        if (this.field != null) {
            return this.field;
        }
        return this.createFieldInt();
    }

    private HasTextValue createFieldInt() {
        this.field = new TF();
        this.field.setWidthFull();
        this.add(new Component[]{(TF)this.field});
        this.customizeTextField(this.field);
        ((TF)this.field).addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (e.isFromClient()) {
                this.field.setValue(this.format(this.getModelValue((String)e.getValue())));
            }
        });
        return this.field;
    }

    @Override
    public void disablePaste() {
        this.createField();
        if (this.field instanceof DisablePaste) {
            ((DisablePaste)((Object)this.field)).disablePaste();
        }
    }

    public HasTextValue getField() {
        if (this.field == null) {
            this.field = this.createField();
            if (this.field == null) {
                this.field = this.createFieldInt();
            }
            if (!(this.field instanceof TF)) {
                if (this.field instanceof Component) {
                    this.add(new Component[]{(Component)this.field});
                }
                this.field.setWidthFull();
                this.customizeTextField(this.field);
            }
        }
        return this.field;
    }

    protected void customizeTextField(HasTextValue textField) {
    }

    protected void onAttach(AttachEvent attachEvent) {
        this.getField();
        super.onAttach(attachEvent);
    }

    protected abstract T getModelValue(String var1);

    protected T generateModelValue() {
        String fv2;
        String fv1 = this.getField().getValue();
        T v = this.getModelValue(this.getField().getValue());
        String string = fv2 = this.emptyDisplay == null || !Objects.equals(this.getEmptyValue(), v) ? this.format(v) : this.emptyDisplay;
        if (!Objects.equals(fv1, fv2)) {
            this.getField().setValue(fv2);
        }
        return v;
    }

    protected void setPresentationValue(T value) {
        this.getField().setValue(this.format(value));
    }

    protected String format(T value) {
        return value == null ? "" : value.toString();
    }

    public void setEmptyDisplay(String emptyDisplay) {
        this.emptyDisplay = emptyDisplay;
        if (emptyDisplay == null) {
            return;
        }
        if (Objects.equals(this.getValue(), this.getEmptyValue()) && emptyDisplay.equals(this.getField().getValue())) {
            return;
        }
        this.getField().setValue(emptyDisplay);
    }

    public void setPlaceholder(String placeholder) {
        HasTextValue f = this.getField();
        if (f instanceof TextField) {
            ((TextField)f).setPlaceholder(placeholder);
        }
    }

    public void setPrefixComponent(Component component) {
        if (this.field instanceof HasPrefix) {
            ((HasPrefix)this.field).setPrefixComponent(component);
        }
    }

    public Component getPrefixComponent() {
        return this.field instanceof HasPrefix ? ((HasPrefix)this.field).getPrefixComponent() : null;
    }

    public void setSuffixComponent(Component component) {
        if (this.field instanceof HasSuffix) {
            ((HasSuffix)this.field).setSuffixComponent(component);
        }
    }

    public Component getSuffixComponent() {
        return this.field instanceof HasSuffix ? ((HasSuffix)this.field).getSuffixComponent() : null;
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        if (this.field instanceof HasValue) {
            ((HasValue)this.field).setReadOnly(readOnly);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.field instanceof HasEnabled) {
            ((HasEnabled)this.field).setEnabled(enabled);
        }
        ((TextField)this.getField()).isAutoselect();
    }

    public void setAutoselect(boolean autoselect) {
        ((TextField)this.getField()).setAutoselect(autoselect);
    }

    public boolean isAutoselect() {
        return ((TextField)this.getField()).isAutoselect();
    }

    public Autocomplete getAutocomplete() {
        return this.getField().getAutocomplete();
    }

    public void setAutocomplete(Autocomplete autocomplete) {
        this.getField().setAutocomplete(autocomplete);
    }

    @Override
    public Element getInternalElement() {
        return this.field.getElement();
    }

    private static class TF
    extends TextField
    implements HasSize,
    HasTextValue,
    DisablePaste {
        private TF() {
        }
    }
}

