/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasValue;
import java.io.Serializable;

public abstract class CustomField<T>
extends com.vaadin.flow.component.customfield.CustomField<T> {
    public CustomField(T defaultValue) {
        super(defaultValue);
    }

    public void addField(HasValue<?, ?> ... fields) {
        this.addField((HasComponents)null, fields);
    }

    public void addField(HasComponents container, HasValue<?, ?> ... fields) {
        for (HasValue<?, ?> field : fields) {
            if (field instanceof Component) {
                if (container == null) {
                    this.add(new Component[]{(Component)field});
                } else {
                    container.add(new Component[]{(Component)field});
                }
            }
            field.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                if (e.isFromClient()) {
                    this.updateValue();
                }
            });
        }
    }

    public void focus() {
        if (this.getChildren().noneMatch(CustomField::focus)) {
            super.focus();
        }
    }

    private static boolean focus(Component component) {
        if (!component.isVisible() || component instanceof HasValue && ((HasValue)component).isReadOnly()) {
            return false;
        }
        if (component instanceof Focusable) {
            Focusable focusable = (Focusable)component;
            if (!focusable.isEnabled()) {
                return false;
            }
            focusable.focus();
            return true;
        }
        return false;
    }
}

