/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.Button;
import com.storedobject.vaadin.ButtonLayout;
import com.storedobject.vaadin.ClickHandler;
import com.storedobject.vaadin.Icon;
import com.storedobject.vaadin.StyledText;
import com.storedobject.vaadin.ThemeStyle;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.contextmenu.ContextMenu;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.function.BooleanSupplier;

public class ConfirmButton
extends Button {
    private BooleanSupplier preconfirm;
    private Yes yes;
    private ContextMenu menu;
    private ButtonLayout buttons;
    private StyledText message;

    public ConfirmButton(String text, ClickHandler clickHandler) {
        this(text, clickHandler, null);
    }

    public ConfirmButton(Component icon, ClickHandler clickHandler) {
        this(icon, clickHandler, null);
    }

    public ConfirmButton(String text, String icon, ClickHandler clickHandler) {
        this(text, icon, clickHandler, null);
    }

    public ConfirmButton(String text, Component icon, ClickHandler clickHandler) {
        this(text, icon, clickHandler, null);
    }

    public ConfirmButton(VaadinIcon icon, ClickHandler clickHandler) {
        this(icon, clickHandler, null);
    }

    public ConfirmButton(String text, VaadinIcon icon, ClickHandler clickHandler) {
        this(text, icon, clickHandler, null);
    }

    public ConfirmButton(String text, ClickHandler clickHandler, String message) {
        super(text, null);
        this.init(clickHandler, message);
    }

    public ConfirmButton(Component icon, ClickHandler clickHandler, String message) {
        super(icon, null);
        this.init(clickHandler, message);
    }

    public ConfirmButton(String text, String icon, ClickHandler clickHandler, String message) {
        super(text, icon, null);
        this.init(clickHandler, message);
    }

    public ConfirmButton(String text, Component icon, ClickHandler clickHandler, String message) {
        super(text, icon, null);
        this.init(clickHandler, message);
    }

    public ConfirmButton(VaadinIcon icon, ClickHandler clickHandler, String message) {
        super(icon, null);
        this.init(clickHandler, message);
    }

    public ConfirmButton(String text, VaadinIcon icon, ClickHandler clickHandler, String message) {
        super(text, icon, null);
        this.init(clickHandler, message);
    }

    private void init(ClickHandler clickHandler, String message) {
        this.message = new StyledText(message == null ? "Are you sure?" : message);
        this.getElement().appendChild(new Element[]{new Icon(VaadinIcon.CHEVRON_DOWN_SMALL).getElement()});
        this.getElement().getStyle().set("background", "var(--lumo-error-color-10pct)");
        this.yes = new Yes(clickHandler);
        this.buttons = new ButtonLayout(new Component[]{new Button("No", (ClickHandler & Serializable)e -> {}).asSmall(), this.yes});
        this.createMenu();
    }

    private void createMenu() {
        if (this.menu != null) {
            this.menu.setTarget(null);
            this.menu.removeAll();
        }
        this.menu = new ContextMenu((Component)this);
        this.menu.setOpenOnClick(true);
        this.menu.addOpenedChangeListener((ComponentEventListener & Serializable)e -> {
            if (e.isOpened() && this.preconfirm != null && !this.preconfirm.getAsBoolean()) {
                this.menu.close();
            }
        });
        this.menu.addItem((Component)this.message);
        this.menu.addItem((Component)this.buttons, null);
    }

    @Override
    public Registration addClickHandler(ClickHandler clickHandler) {
        if (clickHandler == null || this.yes == null) {
            return null;
        }
        if (this.yes.handler == null) {
            this.yes.handler = clickHandler;
            return (Registration & Serializable)() -> {
                this.yes.handler = null;
            };
        }
        return super.addClickHandler(clickHandler);
    }

    public void setPreconfirm(BooleanSupplier preconfirm) {
        this.preconfirm = preconfirm;
    }

    private class Yes
    extends Button
    implements ClickHandler {
        private ClickHandler handler;

        public Yes(ClickHandler clickHandler) {
            super("Yes", null);
            this.handler = clickHandler;
            this.addClickHandler(this);
            this.addTheme(new ThemeStyle[]{ThemeStyle.ERROR, ThemeStyle.SMALL});
        }

        @Override
        public void clicked(Component c) {
            if (this.handler != null) {
                this.handler.clicked((Component)ConfirmButton.this);
            }
        }
    }
}

