/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.SpellCheck;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.combobox.dataview.ComboBoxListDataView;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ComboField<T>
extends ComboBox<T>
implements SpellCheck {
    @SafeVarargs
    public ComboField(T ... list) {
        this(null, list);
    }

    @SafeVarargs
    public ComboField(String label, T ... list) {
        this(label, (Collection<T>)Arrays.asList(list));
    }

    public ComboField(Collection<T> list) {
        this((String)null, list);
    }

    public ComboField(String label, Collection<T> list) {
        super(label);
        this.setItems(list);
    }

    public int getIndex(T item) {
        ComboBoxListDataView view = this.getListDataView();
        for (int i = 0; i < view.getItemCount(); ++i) {
            if (!view.getItem(i).equals(item)) continue;
            return i;
        }
        return -1;
    }

    public T getValue(int index) {
        ComboBoxListDataView view = this.getListDataView();
        if (index < 0 || index >= view.getItemCount()) {
            return null;
        }
        return (T)view.getItem(index);
    }

    public void setIndex(int index) {
        ComboBoxListDataView view = this.getListDataView();
        if (index < 0 || index >= view.getItemCount()) {
            return;
        }
        this.setValue(view.getItem(index));
        this.getListDataView();
    }

    public int getIndex() {
        return this.getIndex(this.getValue());
    }

    public T getEmptyValue() {
        return null;
    }

    public int size() {
        return this.getListDataView().getItemCount();
    }

    public Stream<T> items() {
        return this.getListDataView().getItems();
    }

    @SafeVarargs
    public final ComboBoxListDataView<T> setItems(T ... items) {
        return this.setItems(Arrays.asList(items));
    }

    public ComboBoxListDataView<T> removeItems(Collection<T> items) {
        return (ComboBoxListDataView)this.getListDataView().removeItems(items);
    }

    @SafeVarargs
    public final ComboBoxListDataView<T> removeItems(T ... items) {
        return this.removeItems((Collection<T>)Arrays.asList(items));
    }

    public ComboBoxListDataView<T> removeItems(Stream<T> items) {
        return this.addItems(items.collect(Collectors.toList()));
    }

    public ComboBoxListDataView<T> addItems(Collection<T> items) {
        return (ComboBoxListDataView)this.getListDataView().addItems(items);
    }

    @SafeVarargs
    public final ComboBoxListDataView<T> addItems(T ... items) {
        return this.addItems((Collection<T>)Arrays.asList(items));
    }

    public ComboBoxListDataView<T> addItems(Stream<T> items) {
        return this.addItems(items.collect(Collectors.toList()));
    }
}

