/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.ClickHandler;
import com.storedobject.vaadin.util.ClickNotifier;
import com.storedobject.vaadin.util.ElementClick;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.shared.Registration;

public class Clickable<T extends Component>
extends Composite<T>
implements ClickNotifier {
    private final T component;
    private final ElementClick click;

    public Clickable(T component) {
        this(component, null);
    }

    public Clickable(T component, ClickHandler clickHandler) {
        this.component = component;
        this.click = new ElementClick((Component)component);
        if (clickHandler != null) {
            this.addClickHandler(clickHandler);
        }
    }

    protected T initContent() {
        return this.component;
    }

    public Registration addClickListener(ComponentEventListener<ClickEvent<Component>> listener) {
        return this.click.addClickListener(listener);
    }

    @Override
    public void removeClickListener(ComponentEventListener<ClickEvent<Component>> listener) {
        this.click.removeClickListener(listener);
    }

    public Registration addClickHandler(ClickHandler clickHandler) {
        if (clickHandler == null) {
            return null;
        }
        return this.addClickListener(ClickHandler.convert(clickHandler));
    }
}

