/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import java.io.Serializable;

@FunctionalInterface
public interface ClickHandler
extends ComponentEventListener<ClickEvent<? extends Component>> {
    public void clicked(Component var1);

    default public void doubleClicked(Component c) {
        this.clicked(c);
    }

    default public void rightClicked(Component c) {
        this.clicked(c);
    }

    default public void clicked(ClickEvent<? extends Component> event) {
        Component c = event.getSource();
        if (event.getButton() == 2) {
            this.rightClicked(c);
        } else if (event.getClickCount() == 1) {
            this.clicked(c);
        } else {
            this.doubleClicked(c);
        }
    }

    default public void onComponentEvent(ClickEvent<? extends Component> event) {
        this.clicked(event);
    }

    public static <T extends Component> ComponentEventListener<ClickEvent<T>> convert(ClickHandler clickHandler) {
        return (ComponentEventListener & Serializable)e -> {
            if (clickHandler != null) {
                clickHandler.onComponentEvent((ClickEvent<? extends Component>)e);
            }
        };
    }

    public static ClickHandler transfer(final ClickHandler clickHandler, final Component another) {
        return new ClickHandler(){

            @Override
            public void clicked(Component c) {
                if (clickHandler != null) {
                    clickHandler.clicked(another);
                }
            }

            @Override
            public void onComponentEvent(ClickEvent<? extends Component> event) {
                if (clickHandler != null) {
                    clickHandler.onComponentEvent(new ModifiedClickEvent<Component>(event, another));
                }
            }
        };
    }

    public static class ModifiedClickEvent<C extends Component>
    extends ClickEvent<C> {
        public ModifiedClickEvent(ClickEvent<C> original, Component to) {
            super(to, original.isFromClient(), original.getScreenX(), original.getScreenY(), original.getClientX(), original.getClientY(), original.getClickCount(), original.getButton(), original.isCtrlKey(), original.isShiftKey(), original.isAltKey(), original.isMetaKey());
        }
    }
}

