/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.Box;
import com.storedobject.vaadin.ButtonLayout;
import com.storedobject.vaadin.CSSGrid;
import com.storedobject.vaadin.CustomField;
import com.storedobject.vaadin.GridLayout;
import com.storedobject.vaadin.RadioChoiceField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ChoicesField
extends CustomField<Integer> {
    private static final Integer ZERO = 0;
    private HasComponents container;
    private final ArrayList<Checkbox> list = new ArrayList();
    private int valueMask = 0;
    private RadioChoiceField fullSelect;

    public ChoicesField(String choices) {
        this(null, choices);
    }

    public ChoicesField(String label, String choices) {
        this(label, (Collection<String>)Arrays.asList(choices.split(",")));
    }

    public ChoicesField(String[] choices) {
        this(null, choices);
    }

    public ChoicesField(String label, String[] choices) {
        this(label, (Collection<String>)Arrays.asList(choices));
    }

    public ChoicesField(Iterable<?> choices) {
        this(null, choices);
    }

    public ChoicesField(String label, Iterable<?> choices) {
        this(label, ChoicesField.createList(choices));
    }

    public ChoicesField(String label, Collection<String> choices) {
        super(ZERO);
        ChoicesField.sanitize(choices).forEach(item -> {
            Checkbox cb = new Checkbox(item);
            this.list.add(cb);
        });
        this.createGrid(choices.size() > 4 ? 2 : 0, this.createContainer());
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.checkMask((Integer)e.getValue()));
        this.setValue(ZERO);
        this.setLabel(label);
    }

    private void checkMask(int newValue) {
        if ((newValue & this.valueMask) != this.valueMask) {
            this.setValue(newValue | this.valueMask);
        }
    }

    private static Collection<String> createList(Iterable<?> list) {
        ArrayList<String> a = new ArrayList<String>();
        list.forEach(item -> {
            String s = null;
            if (item != null) {
                s = item.toString();
            }
            if (s != null) {
                a.add(s.trim());
            }
        });
        return a;
    }

    private static Collection<String> sanitize(Collection<String> collection) {
        if (!(collection instanceof List)) {
            return collection;
        }
        List list = (List)collection;
        for (int i = 0; i < list.size(); ++i) {
            String item = (String)list.get(i);
            if (!item.isEmpty()) continue;
            list.set(i, " ");
        }
        return list;
    }

    protected HasComponents createContainer() {
        return null;
    }

    private void createGrid(int columns, HasComponents c) {
        this.fullSelect = null;
        if (c != null) {
            this.container = c;
        } else {
            if (columns > 0) {
                GridLayout layout = new GridLayout(columns);
                if (this.list.size() > 4) {
                    this.fullSelect = new RadioChoiceField(new String[]{"All", "None"});
                    this.fullSelect.setValue(1);
                    this.fullSelect.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                        if (!this.isReadOnly()) {
                            this.setValue((Integer)e.getValue() == 0 ? 65535 : 0);
                        }
                    });
                    Box b = new Box((Component)this.fullSelect);
                    b.setPadding(0);
                    b.setBorderWidth("0px 0px 2px 0px");
                    layout.add(new Component[]{this.fullSelect});
                    layout.setColumnSpan((Component)this.fullSelect, columns);
                    layout.justify((Component)this.fullSelect, CSSGrid.Position.CENTER);
                }
                this.container = layout;
            } else {
                this.container = new ButtonLayout();
            }
            Box box = new Box((Component)this.container);
            box.setPadding(0);
        }
        this.list.forEach(xva$0 -> this.container.add(new Component[]{xva$0}));
        this.add(new Component[]{(Component)this.container});
    }

    public void setColumns(int columns) {
        if (columns > this.list.size()) {
            columns = this.list.size();
        }
        if (columns > 6) {
            columns = 6;
        }
        this.container.removeAll();
        this.remove(new Component[]{(Component)this.container});
        this.createGrid(columns, null);
    }

    protected Integer generateModelValue() {
        int v = 0;
        int i = 1;
        for (Checkbox c : this.list) {
            if (((Boolean)c.getValue()).booleanValue()) {
                v |= i;
            }
            i <<= 1;
        }
        return v;
    }

    protected void setPresentationValue(Integer value) {
        int v = value;
        int i = 1;
        for (Checkbox c : this.list) {
            if (((Boolean)c.getValue()).booleanValue()) {
                if ((v & i) == 0) {
                    c.setValue((Object)false);
                }
            } else if ((v & i) > 0) {
                c.setValue((Object)true);
            }
            i <<= 1;
        }
    }

    public void setValueMask(int valueMask) {
        this.valueMask = valueMask;
        this.checkMask((Integer)this.getValue());
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        if (this.fullSelect != null) {
            this.fullSelect.setReadOnly(readOnly);
        }
    }
}

