/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.ListField;
import com.storedobject.vaadin.TranslatedField;
import com.storedobject.vaadin.ValueRequired;
import com.vaadin.flow.component.select.Select;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ChoiceField
extends TranslatedField<Integer, String>
implements ValueRequired {
    public ChoiceField(String choices) {
        this(null, choices);
    }

    public ChoiceField(String label, String choices) {
        this(label, (Collection<String>)Arrays.asList(choices.split(",")));
    }

    public ChoiceField(String[] choices) {
        this(null, choices);
    }

    public ChoiceField(String label, String[] choices) {
        this(label, (Collection<String>)Arrays.asList(choices));
    }

    public ChoiceField(Iterable<?> list) {
        this(null, list);
    }

    public ChoiceField(String label, Iterable<?> list) {
        this(label, ChoiceField.createList(list));
    }

    public ChoiceField(String label, Collection<String> list) {
        super(ChoiceField.createField(list), (f, s) -> ((ListField)f).getIndex(s), (f, v) -> v == null ? null : (String)((ListField)f).getValue((int)v), null);
        this.setPlaceholder("Select");
        this.setValue(0);
        this.setLabel(label);
    }

    private static ListField<String> createField(Collection<String> list) {
        ListField<String> field = new ListField<String>(ChoiceField.sanitize(list));
        field.setRequired(true);
        return field;
    }

    private static Collection<String> createList(Iterable<?> list) {
        ArrayList<String> a = new ArrayList<String>();
        list.forEach(item -> {
            String s = null;
            if (item != null) {
                s = item.toString();
            }
            if (s != null) {
                a.add(s.trim());
            }
        });
        return a;
    }

    private static Collection<String> sanitize(Collection<String> collection) {
        if (!(collection instanceof List)) {
            return collection;
        }
        List list = (List)collection;
        for (int i = 0; i < list.size(); ++i) {
            String item = (String)list.get(i);
            if (!item.isEmpty()) continue;
            list.set(i, " ");
        }
        return list;
    }

    public String getChoice() {
        return (String)this.getField().getValue();
    }

    public void setChoice(String value) {
        this.getField().setValue((Object)value);
    }

    public void setChoice(int index, String choice) {
        ((ListField)this.getField()).setItem(index, choice);
    }

    public void setChoices(Collection<String> choices) {
        int v = (Integer)this.getValue();
        ListField f = (ListField)this.getField();
        f.setItems(choices);
        f.setValue((String)f.getValue(v));
    }

    public void setChoices(Iterable<String> choices) {
        int v = (Integer)this.getValue();
        ListField f = (ListField)this.getField();
        f.setItems(choices);
        f.setValue((String)f.getValue(v));
    }

    public void setChoices(String[] choices) {
        int v = (Integer)this.getValue();
        ListField f = (ListField)this.getField();
        f.setItems((T[])choices);
        f.setValue((String)f.getValue(v));
    }

    public void setPlaceholder(String placeholder) {
        ((Select)this.getField()).setPlaceholder(placeholder);
    }

    public String getPlaceholder() {
        return ((Select)this.getField()).getPlaceholder();
    }

    @Override
    public void setRequired(boolean required) {
        ((ListField)this.getField()).setRequired(required);
    }

    @Override
    public boolean isRequired() {
        return ((ListField)this.getField()).isRequired();
    }

    public void setValue(Integer value) {
        if (value == null && this.isRequired()) {
            value = 0;
        }
        super.setValue((Object)value);
    }
}

