/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.HasSize;
import com.storedobject.vaadin.HasStyle;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasOrderedComponents;
import com.vaadin.flow.component.Tag;

@Tag(value="div")
public class CSSGrid
extends Component
implements HasOrderedComponents,
HasStyle,
HasSize {
    public CSSGrid() {
        this.style("display", "grid");
        this.style("align-items", "center");
        this.style("justify-items", "start");
        this.setGap("4px");
        this.style("transition", "all 1s");
    }

    public void setGap(String size) {
        this.style("grid-row-gap", size == null ? "1px" : size);
        this.style("grid-column-gap", size == null ? "1px" : size);
    }

    public void setGap(int size) {
        this.setGap(Math.max(size, 0) + "px");
    }

    public void setColumnGap(String size) {
        this.style("grid-column-gap", size == null ? "1px" : size);
    }

    public void setColumnGap(int size) {
        this.setColumnGap(Math.max(size, 0) + "px");
    }

    public void setRowGap(String size) {
        this.style("grid-row-gap", size == null ? "1px" : size);
    }

    public void setRowGap(int size) {
        this.setRowGap(Math.max(size, 0) + "px");
    }

    protected void style(String styleName, String styleValue) {
        this.getStyle().set(styleName, styleValue);
    }

    public void justify(Component component, Position position) {
        if (position == null) {
            position = Position.STRETCH;
        }
        component.getElement().getStyle().set("justify-self", position.toString().toLowerCase());
    }

    public void align(Component component, Position position) {
        if (position == null) {
            position = Position.STRETCH;
        }
        component.getElement().getStyle().set("align-self", position.toString().toLowerCase());
    }

    public void center(Component component) {
        this.justify(component, Position.CENTER);
        this.align(component, Position.CENTER);
    }

    public void setColumnSpan(Component component, int columns) {
        if (columns < 1) {
            columns = 1;
        }
        component.getElement().getStyle().set("grid-column", "span " + columns);
    }

    public int getColumnSpan(Component component) {
        return this.getSpan(component, "column");
    }

    public void setRowSpan(Component component, int rows) {
        if (rows < 1) {
            rows = 1;
        }
        component.getElement().getStyle().set("grid-row", "span " + rows);
    }

    public int getRowSpan(Component component) {
        return this.getSpan(component, "row");
    }

    private int getSpan(Component component, String of) {
        try {
            return Integer.parseInt(component.getElement().getStyle().get("grid-" + of).replace(" ", "").replace("span", ""));
        }
        catch (Throwable throwable) {
            return 1;
        }
    }

    public static enum Position {
        START,
        END,
        CENTER,
        STRETCH;

    }
}

