/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.InvisibleComponent;
import com.storedobject.vaadin.StickyElement;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.dom.Style;

public class ButtonLayout
extends FlexLayout
implements StickyElement {
    private int margin = 5;

    public ButtonLayout() {
        this(null);
    }

    public ButtonLayout(Component ... components) {
        this.getStyle().set("flex-wrap", "wrap").set("align-items", "center").set("align-content", "space-around");
        if (components != null) {
            this.add(components);
        }
    }

    public void setGap(int gap) {
        String m = this.margin + "px";
        this.getChildren().filter(c -> m.equals(c.getElement().getStyle().get("margin-right"))).forEach(c -> ButtonLayout.m(c, gap));
        this.margin = gap;
    }

    public int getGap() {
        return this.margin;
    }

    public void add(Component ... components) {
        if (components == null) {
            return;
        }
        for (Component c : components) {
            this.add(c, this.margin);
        }
    }

    public void add(Component c, int margin) {
        if (c == null) {
            return;
        }
        ButtonLayout.m(c, margin);
        super.add(new Component[]{c});
    }

    public Component addFiller() {
        Filler filler = new Filler();
        this.add(new Component[]{filler});
        return filler;
    }

    public static Component createFiller() {
        return new Filler();
    }

    private static void m(Component c, int margin) {
        if (!(c instanceof InvisibleComponent)) {
            c.getElement().getStyle().set("margin-right", margin + "px");
        }
    }

    private static class Filler
    extends Span
    implements InvisibleComponent {
        private Filler() {
            Style s = this.getStyle();
            s.set("display", "flex");
            s.set("flex-grow", "100");
        }
    }
}

