/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.Box;
import com.storedobject.vaadin.ClickHandler;
import com.storedobject.vaadin.HasIcon;
import com.storedobject.vaadin.HasSquareElement;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;

@Tag(value="paper-icon-button")
@NpmPackage(value="@polymer/paper-icon-button", version="3.0.2")
@JsModule(value="@polymer/paper-icon-button/paper-icon-button.js")
public class ButtonIcon
extends Component
implements HasSquareElement,
HasIcon,
ClickNotifier<ButtonIcon> {
    public ButtonIcon(String icon, ClickHandler clickHandler) {
        this(icon, ClickHandler.convert(clickHandler));
    }

    public ButtonIcon(String icon) {
        this(icon, (ComponentEventListener<ClickEvent<ButtonIcon>>)((ComponentEventListener)null));
    }

    private ButtonIcon(String icon, ComponentEventListener<ClickEvent<ButtonIcon>> listener) {
        this.setIcon(icon);
        if (listener != null) {
            this.addClickListener(listener);
        }
    }

    public void setInkColor(String color) {
        this.setStyle("--paper-icon-button-ink-color", color);
    }

    public String getInkColor() {
        return this.getStyle("--paper-icon-button-ink-color");
    }

    public void setPlaceholder(String placeholder) {
        this.getElement().setAttribute("title", placeholder == null ? "" : placeholder);
    }

    public ButtonIcon withBox() {
        return this.withBox(25);
    }

    public ButtonIcon withBox(int sizeInPixels) {
        if (sizeInPixels < 5) {
            sizeInPixels = 25;
        }
        Box box = new Box(this);
        this.setSize(sizeInPixels + "px");
        box.alignSizing();
        box.grey();
        return this;
    }
}

